import os
import time

from ..shared import define

####################################################
# PYTHON_PATH = "user python path"

# 環境変数を取得する例
# 取得したい環境変数名を指定


# os.getenv() で取得（存在しない場合は None を返す）
PYTHON_PATH = define.PYTHON_PATH


####################################################


class ToolsDataBase():
    def __init__(self):
        self.python_program_dict = {}
        self.ai_agent_dict = {}
        self.main_ai_agent_dict = {}

g_tdb = ToolsDataBase()


def create_folder(folder_path):
    """指定されたフォルダが存在しない場合、フォルダを作成します。

    Args:
      folder_path: 作成するフォルダのパス。
    """
    folder_path = folder_path.replace("\\", "/")
    if not os.path.exists(folder_path):
        os.makedirs(folder_path)
    if folder_path.endswith("/"):
        return folder_path
    else:
        return folder_path + "/"

def get_parent_directory(file_path):
    """__file__からファイル名を除いてさらに親フォルダのパスを得る関数。

    Args:
        file_path: ファイルのパス。

    Returns:
        親フォルダのパス。ファイルが存在しない場合はNoneを返す。
    """
    if not os.path.exists(file_path):
        return None
    parent_dir = os.path.dirname(file_path)
    grandparent_dir = os.path.dirname(parent_dir)
    return grandparent_dir


WORK_SPACE_DIR = define.WORK_SPACE_DIR

AGENT_SPACE_DIR = define.AGENT_SPACE_DIR

CODE_SPACE_DIR = define.CODE_SPACE_DIR

DELOVERABLES_SPACE_DIR = define.DELOVERABLES_SPACE_DIR

TEMP_SPACE_DIR = define.TEMP_SPACE_DIR



####################################################


def save_text(file_name:str, data):
    while 0 <=file_name.find("../") or 0 <= file_name.find("..\\"):
        file_name = file_name.replace("../", "")
        file_name = file_name.replace("..\\", "")
    data = data.replace("\\r", "\r")
    data = data.replace("\\n", "\n")

    try:
        with open(WORK_SPACE_DIR+file_name, 'wb') as f_out:
            f_out.write(data.encode())
    except PermissionError:
        print(f"ファイルへの書き込み権限がありません: {file_name}")
    except OSError as e:
        print(f"ファイル書き込み中にエラーが発生しました: {e}")
    except Exception as e:
        print(f"ファイル書き込み中にエラーが発生しました: {e}")


def load_text(file_name):
    while 0 <=file_name.find("../") or 0 <= file_name.find("..\\"):
        file_name = file_name.replace("../", "")
        file_name = file_name.replace("..\\", "")
    full_path = WORK_SPACE_DIR+file_name
    
    if os.path.exists(full_path):
        try:
            with open(full_path, 'rb') as f_in:
                data = f_in.read()
            return data.decode('utf-8')

        except Exception as e:
            print(f"ファイル読み込み中にエラーが発生しました: {e}")

    else:
        print(f"{full_path}\r\nファイルが見つかりませんでした")
    return None
