import subprocess

from ..shared import define

def run_pip_command(command: str, module_name: str) -> str:
    """
    pipコマンドを実行する関数。
    Args:
        command: 実行するpip のコマンド　例: install　など。
        module_name: コマンドの対称としたいモジュールの名p

    Returns:
        実行結果と標準出力。エラーが発生した場合は、エラーメッセージと標準出力を返します。
    """
    print("run_pip_command:")

    try:
        # Pythonのバージョンを自動検出する。shebang行で指定されているバージョンを使うのが理想的だが、ここではシステムのデフォルトを使う。
        command = [define.PYTHON_PATH, '-m', 'pip', command, module_name]
        # check=Trueでエラーを例外として扱う
        process = subprocess.run(command, capture_output=True,
                                 text=True, check=True)

        return process.stdout
    except subprocess.CalledProcessError as e:
        return f"pipコマンドの実行に失敗しました: 戻り値={e.returncode},\
標準出力={e.stdout}, 標準エラー出力={e.stderr}"
    except FileNotFoundError:
        return "pipコマンドが見つかりません。pipがインストールされていることを確認してください。"
    except Exception as e:
        return f"予期せぬエラーが発生しました: {e}"
###################################################
