
import os

##################


def _create_folder(folder_path):
    """指定されたフォルダが存在しない場合、フォルダを作成します。

    Args:
      folder_path: 作成するフォルダのパス。
    """
    folder_path = folder_path.replace("\\", "/")
    if not os.path.exists(folder_path):
        os.makedirs(folder_path)
    if folder_path.endswith("/"):
        return folder_path
    else:
        return folder_path + "/"
def _get_parent_directory(file_path):
    """__file__からファイル名を除いてさらに親フォルダのパスを得る関数。

    Args:
        file_path: ファイルのパス。

    Returns:
        親フォルダのパス。ファイルが存在しない場合はNoneを返す。
    """
    if not os.path.exists(file_path):
        return None
    parent_dir = os.path.dirname(file_path)
    grandparent_dir = os.path.dirname(parent_dir)
    return grandparent_dir
    
####################


env_var_name = "AI_USE_PYTHON_PATH"

# os.getenv() で取得（存在しない場合は None を返す）
PYTHON_PATH = os.getenv(env_var_name)

if PYTHON_PATH is None:
    env_var_name = "PYTHON_PATH"
    PYTHON_PATH = os.getenv(env_var_name)
    if PYTHON_PATH is None:
        print("error:環境変数AI_USE_PYTHON_PATHまたはPYTHON_PATHが設定されていません。")
####################################################


WORK_SPACE_DIR = _create_folder(_get_parent_directory(_get_parent_directory(__file__)+"/"))
DATA_SPACE_DIR = _create_folder(os.path.join(WORK_SPACE_DIR, "Data"))
AGENT_SPACE_DIR = _create_folder(os.path.join(WORK_SPACE_DIR,  "Agents"))
CODE_SPACE_DIR = _create_folder(os.path.join(DATA_SPACE_DIR, "Code"))
DELOVERABLES_SPACE_DIR = _create_folder(os.path.join(DATA_SPACE_DIR, "Deliverables"))
TEMP_SPACE_DIR = _create_folder(os.path.join(DATA_SPACE_DIR, "Temp"))

RELATIVE_DATA_SPACE_DIR="Data/"
RELATIVE_AGENT_SPACE_DIR="Agents/"
RELATIVE_CODE_SPACE_DIR="Data/Code/"
RELATIVE_DELOVERABLES_SPACE_DIR="Data/Deliverables/"
RELATIVE_TEMP_SPACE_DIR="Data/Temp/"




def set_agent_space(space):
    global AGENT_SPACE_DIR
    AGENT_SPACE_DIR = _create_folder(space)


def set_code_space(space):
    global CODE_SPACE_DIR
    CODE_SPACE_DIR = _create_folder(space)


def set_deliverables_space(space):
    global DELOVERABLES_SPACE_DIR
    DELOVERABLES_SPACE_DIR = _create_folder(space)


def set_temp_space(space):
    global TEMP_SPACE_DIR
    TEMP_SPACE_DIR = _create_folder(space)


def set_work_space(space):
    global WORK_SPACE_DIR
    WORK_SPACE_DIR = _create_folder(space)
    WORK_SPACE_DIR = WORK_SPACE_DIR.replace("\\", "/")

    set_agent_space(os.path.join(WORK_SPACE_DIR,"Agents"))
    set_code_space(os.path.join(DATA_SPACE_DIR,"Code"))
    set_deliverables_space(os.path.join(DATA_SPACE_DIR,"Deliverables"))
    set_temp_space(os.path.join(DATA_SPACE_DIR,"Deliverables"))


