

from langchain_core.tools import tool
from pydantic import BaseModel, Field

import os
from ..FileList import FileList
from ..shared.text_file_io import save_text as __save_text
from ..shared.text_file_io import load_text as __load_text
from ..shared import define 




class TextEditor():
    


    def __init__(self, current_dir):
        self.current_dir = current_dir
        FileList().create_folder(self.current_dir)
        self.working_file = ""
        self.text_lines = []
        self.obj={"file":"",
                  "data":""
                  }
     
    def __check_data_has_line_number(self, data):
        lines = data.split("\n")
        if 0 < len(lines):
            for line in lines:
                line = line.strip()
                if line == "":
                    continue
                if 0 < len(line.split("|")):
                    if line.split("|")[0].isdecimal():

                        continue
                return False
            return True
        return False


    def _load_line_number_append(self, file_name):

        self.text_lines = __load_text(os.path.join(self.current_dir, file_name)).split("\n")
        result =""
        for i in range(len(self.text_lines)):
            result +=str(i+1).rjust(5) +"|"+self.text_lines[i]

        return result

    def _save(self, file_name, data):

        if self.__check_data_has_line_number(data):
            self._save_appended_line_number_data(file_name, data)
        else:
            self.text_lines = data.split("\n")
            self._save_as_woring_program_data(file_name)




    def _save_appended_line_number_data(self, file_name, data):

        self.text_lines = data.split("\n")
        result =""
        for line, i in zip(self.text_lines, range(len(self.text_lines))):
            self.text_lines[i] = line.split("|")[1]
            result += self.text_lines[i]+"\n"
        __save_text(os.path.join(self.current_dir, file_name), result)



    def _save_as_woring_program_data(self, file_name):

        self.working_file = file_name
        self._save_woring_data()    


    def _save_woring_data(self):

        file_name = self.working_file
        result =""
        for line in self.text_lines:
            result += line + "\n"
        __save_text(os.path.join(self.current_dir, file_name), result)


    #　今回はこれはtoolとしない。AIには行番号付きのデータだけ扱わせる。
    def _get_Working_data(self):
        """
        現在作業中のprogramコードを返します。
        Returns:
            str:現在作業中のprogramコードを返します。
        """
        global self.text_lines
        result =""
        for line in self.text_lines:
            result += line + "\n"
        return result


    #==============================
    # プログラムのファイルリスト管理ツール
    def _get_program_file_descriptions(self) -> str:
        """
        プログラムのデータの保存先フォルダ内のファイルリストを取得します。

        :return: ファイルパスのリスト
        :rtype: List[str]
        """
        return file_list._get_and_create_all_file_descriptions(self.current_dir)
