from PySide6.QtWidgets import QHBoxLayout,QWidget, QCheckBox
class WebSearchWidget(QWidget):
    def __init__(self):
        super().__init__()
        self.layout = QHBoxLayout()
        self.checkbox = QCheckBox("Enable Web Search")
        self.layout.addWidget(self.checkbox)

        self.setLayout(self.layout)


       # チェック状態が変わったときに呼ばれる関数を接続
        self.checkbox.stateChanged.connect(self.on_check_state_changed)

        self.changed_function = None

    def get_checked(self):
        return self.checkbox.isChecked()
    def is_search_enabled(self):
        return self.checkbox.isChecked()
    def set_checked(self, checked):
        self.checkbox.setChecked(checked)
    def set_search_enabled(self, enabled):
        self.checkbox.setChecked(enabled)

    def set_font(self, font):
        self.checkbox.setFont(font)

    def on_check_state_changed(self, state):
        if None is not self.changed_function:
            self.changed_function(self.checkbox.isChecked())

    def set_changed_function(self, func):
        self.changed_function = func