
from PySide6.QtWidgets import QVBoxLayout,QHBoxLayout,QWidget
from PySide6.QtWidgets import QTextEdit, QPushButton

from ..shared.exception import InterruptedException as InterruptedException





class UserInputWidget(QWidget):
    def __init__(self, parent=None):
        super().__init__(parent)
        # Initialize chat widget components here
        # input 入力欄
        self.input_edit = QTextEdit()
        self.input_edit.setMaximumHeight(100)
        self.send_stop_button = QPushButton("↑:Send")
        self.send_stop_button.clicked.connect(self.send_stop_message)
        self.control_layout = QHBoxLayout()
        self.control_layout.addStretch(1)
        self.control_layout.addWidget(self.send_stop_button)


        
        # 全体レイアウト
        self.input_layout = QVBoxLayout()
        self.input_layout.addWidget(self.input_edit)
        self.input_layout.addLayout(self.control_layout)
        # QWidget にレイアウトをセット
        self.setLayout(self.input_layout)
        self.send_stop = True # To toggle between send and stop
        self.send_function = None
        self.stop_function = None

    def get_layout(self):
        return self.input_layout
    
    def get_input_edit(self):
        return self.input_edit
    
    def get_control_layout(self):
        return self.control_layout
    
    def set_agent(self, agent):
        self.agent = agent
    def set_send_function(self, func):
        self.send_function = func
    def set_stop_function(self, func):
        self.stop_function = func
    def send_stop_message(self):
        message = self.input_edit.toPlainText()
        
        if self.send_stop:
            if message:
                self.send_stop_button.setText("■:Stop") # ボタンをSTOPに変更
                self.input_edit.setReadOnly(True)  # 入力欄を読み取り専用に
                self.input_edit.clear()
                self.send_stop = False
                self.send_function(message)
                
        else:     
            self.send_stop = True
            print("Stop All Models button clicked.")
            InterruptedException.set_cancel(True)
            self.input_edit.setReadOnly(False)  # 入力欄を読み取り専用楷書
            self.send_stop_button.setText("↑Send") # ボタンをSendに変更
            self.stop_function()
            self.send_stop = True
            
    def reset_send_button(self):
        self.input_edit.setReadOnly(False)  # 入力欄を読み取り専用楷書
        self.send_stop_button.setText("↑:Send") # ボタンをSendに変更
        self.send_stop = True

    def set_font(self, font):
        self.input_edit.setFont(font)
        self.send_stop_button.setFont(font)
        
    def clear_input(self):
        self.input_edit.clear()

    def insert_layout(self, layout, index: int = 0):
        self.control_layout.insertLayout(index, layout)

    def insert_widget(self, index: int = 0, widget: QWidget = None):
        
        self.control_layout.insertWidget(index, widget)