from PySide6.QtWidgets import QComboBox, QHBoxLayout,QWidget, QLabel, QComboBox, QCheckBox
class ThinkingWidget(QWidget):
    def __init__(self):
        super().__init__()
        self.layout = QHBoxLayout()
        self.label = QLabel("Thinking...")
        self.checkbox = QCheckBox("Enable Thinking")
        self.comboBox = QComboBox()
        self.comboBox.addItems(["Low", "Medium", "High"])
        self.setLayout(self.layout)

    def _clear_layout(self,layout):
        while layout.count():
            item = layout.takeAt(0)
            widget = item.widget()
            if widget is not None:
                widget.setParent(None)
            else:
                # 子レイアウトの場合
                child_layout = item.layout()
                if child_layout is not None:
                    self._clear_layout(child_layout)

    def is_low_medium_high(self):
        self._clear_layout(self.layout)
        self.layout.addWidget(self.label)
        self.layout.addWidget(self.comboBox)

    def is_thinking_boolean(self):
        self._clear_layout(self.layout)
        self.layout.addWidget(self.label)
    
    def is_thinking(self):
        self._clear_layout(self.layout)

    def get_now_value(self):
        if self.layout.count() == 2:
            return self.comboBox.currentText()
        elif self.layout.count() == 1:
            return self.checkbox.isChecked()
        else:
            return None

    def set_font(self, font):
        self.label.setFont(font)
        self.comboBox.setFont(font)
        self.checkbox.setFont(font)
        