

from PySide6.QtWidgets import QWidget, QVBoxLayout,QLabel
from PySide6.QtGui import QPainter, QColor, QFont, QPen, QBrush, QMouseEvent, QKeyEvent, QWheelEvent, QTextDocument, QTextCursor
from PySide6.QtCore import Qt, QRect, QPoint
import re
import pyperclip



import time

from ..shared.exception import InterruptedException as InterruptedException



class PaintBaseObject():

    widget_area = None
    def __init__(self):
        pass

    @classmethod
    def set_widget_area(cls, rect):
        cls.widget_area = rect
    @classmethod
    def check_rect_in(cls, rect):
#        if cls.draw_area.y() < rect.y() + rect.height():
#            if rect.y() < cls.draw_area.y() + cls.draw_area.height():
#                return True
        if 0 < rect.y() + rect.height():
            if rect.y() < cls.widget_area.y() + cls.widget_area.height():
                return True
        return False
    
class PaintLabelBox(PaintBaseObject):
    def __init__(self, text=""):
        self.rect = QRect(0, 0, 150, 50)
        self.font = QFont("Arial", 14)
        self.font_name = "Arial" # Store font name
        self.font_size = 14 # フォントサイズを保持
        self.font_color = QColor(0, 0, 0)
        self.align = Qt.AlignLeft
        self.height_fit = True
        self.text = text
        self.fit_text_lines = []
        self.text_posy_list = []
        self.span = 1
        self.border_size = 0
        self.back_color = QColor(255, 255, 255)
        self.border_color = QColor(0, 0, 0)
        
        self.draw_text_rect = QRect(0, 0, 0, 0)
        self.draw_border_rect = QRect(0, 0, 0, 0)
        self.document_text= QTextDocument()
        self.document_text.setDefaultFont(self.font)
        self.document_text.setPlainText(self.text)
        self.blocks = []
        self.block_bottoms = []
        self.__set_text_rect()

        self.__fit_text()

    def set_font_size(self, size):
        self.font_size = size
        self.font = QFont(self.font_name, self.font_size)
        self.document_text.setDefaultFont(self.font)
        self.__fit_text() # フォントサイズ変更後に再計算

    def __set_text_rect(self):
        if self.rect.width() < ((self.span+self.border_size) * 2) or self.rect.height() < ((self.span+self.border_size) * 2): # 最小サイズチェック
            return
        self.text_rect = QRect(
            int(self.rect.x() + self.span+self.border_size),
            int(self.rect.y() + self.span+self.border_size),
            self.rect.width() - (self.span+self.border_size) * 2,
            self.rect.height() - (self.span+self.border_size) * 2)
    def set_font_color(self, color):
        self.font_color = color
    def set_back_color(self, color):
        self.back_color = color
    def set_border_color(self, color):
        self.border_color = color

    def set_border_size(self, size):
        self.border_size = size

    def get_border_size(self):
        return self.border_size

    def set_hieght_fit(self, fit_flag):
        self.height_fit = fit_flag

    def set_size(self, width, hight):
        if width < ((self.span+self.border_size) * 2)*2:
            width = ((self.span+self.border_size) * 2)*2
        if hight < ((self.span+self.border_size) * 2)*2:
            hight = ((self.span+self.border_size) * 2)*2
        self.rect.setRect(self.rect.x(), self.rect.y(), width, hight)


        self.__set_text_rect() # サイズ変更時にtext_rectも更新

        self.document_text.setTextWidth(self.text_rect.width())
 
        
        self.__fit_text()

    def set_width(self, w):
        if w < ((self.span+self.border_size) * 2)*2:
            w = ((self.span+self.border_size) * 2)*2
        self.rect.setRect(self.rect.x(), self.rect.y(), w, self.rect.height())
        self.__set_text_rect()
        st=time.time()
        self.document_text.setTextWidth(self.text_rect.width())



        self.__fit_text()

    def set_position(self, x, y):
        self.rect.setRect(x, y, self.rect.width(), self.rect.height())
        self.__set_text_rect() # 位置変更時にもtext_rectを更新
        self.__fit_text()

    def move(self, x, y):
        self.rect.setRect(self.rect.x() + x, self.rect.y() + y,
                          self.rect.width(), self.rect.height())
        self.__set_text_rect()

    def set_text(self, text):
        self.text = text
        self.document_text.setPlainText(self.text)
        self.__fit_text()


    def get_text(self):
        return self.text
    
    def get_last_line_text(self):
        if 0 < len(self.fit_text_lines) :
            return self.fit_text_lines[-1]
        return ""
    
    def append_text(self, text):
        self.text += text
        cursor =  QTextCursor(self.document_text)
        cursor.movePosition(QTextCursor.End)
        cursor.insertText(text)


        self.__fit_text_last_line(text)

    def delete_last_line(self):

        cursor = QTextCursor(self.document_text)
        cursor.movePosition(QTextCursor.End)  # 文書末尾へ移動

        # 最後のブロックを取得
        block = cursor.block()
        if not block.isValid():
            return
        if "" != block.text():
        
            # 最後のブロック全体を選択して削除
            cursor.select(QTextCursor.BlockUnderCursor)
            cursor.removeSelectedText()
            # 最後が空行でない場合追加
            cursor.movePosition(QTextCursor.End)  # 文書末尾へ移動
            # 最後のブロックを取得
            block = cursor.block()
            if not block.isValid():
                return
            if "" != block.text():
                cursor.insertBlock()

        #cursor.deleteChar()  # ブロック区切り（改行）も削除


        has_newline = self.text.endswith("\n")
        if 1 < len(self.text.split("\n")):
            self.text = self.text.rsplit("\n", 1)[0]
            if not has_newline:
                self.text += "\n"
        else:
            self.text = ""
        if has_newline:
            self.text += "\n"
        
        


    def width(self):
        return self.rect.width()

    def height(self):
        return self.rect.height()

    def x(self):
        return self.rect.x()

    def y(self):
        return self.rect.y()

    def check_rect_in(self):
        if PaintBaseObject.check_rect_in(self.rect):
            return True
        return False
    #  テキストをwidthで改行する
    def set_span(self, span):
        self.span = span

    def set_border(self, bsize):
        self.border_size = bsize

    def get_border(self):
        return self.border_size

    def __fit_text(self):
        
        #self.document_text.setTextWidth(self.text_rect.width())
        #self.blocks, self.block_bottoms = self.build_block_cache(self.document_text)
                

        self.__fit_height()
     
    def __fit_text_last_line(self,append_text):

        self.__fit_height()

    def __fit_height(self):
        if self.height_fit:
            #self.__set_text_rect()
            #self.document_text.setTextWidth(self.text_rect.width())
            #self.blocks, self.block_bottoms = self.build_block_cache(self.document_text)
             
            height_total = self.document_text.size().height()

            new_height = height_total + (self.span+self.border_size)*2
            self.rect = QRect(self.rect.x(), self.rect.y(),
                              self.rect.width(),
                              new_height)

 
            self.__set_text_rect()

            #self.__set_position_y_list()
    def set_align(self, pos_st):

        if "left" == pos_st.lower():
            self.align = Qt.AlignLeft
        elif "center" == pos_st.lower():
            self.align = Qt.AlignCenter
        elif "right" == pos_st.lower():
            self.align = Qt.AlignRight

    def get_align(self):
        return self.align


    def simpole_draw_text(self, painter: QPainter):
        painter.save()
        painter.translate(self.text_rect.x(), self.text_rect.y())
        self.document_text.drawContents(painter)
        painter.restore()

    def draw(self, obj):
        if False == PaintBaseObject.check_rect_in(self.rect):
            return


        painter = QPainter(obj)
        painter.save()        
        painter.setFont(self.font)

        if 0 == self.border_size:
            painter.setPen(QPen(self.back_color, self.border_size))  # 枠線
        else:
            painter.setPen(QPen(self.border_color, self.border_size))  # 枠線
        painter.setBrush(QBrush(self.back_color))  # 塗りつぶし




        painter.setClipRect(PaintBaseObject.widget_area)

        painter.drawRoundedRect(self.rect, self.font_size/2, self.font_size/2)

        painter.setPen(QPen(self.font_color, self.border_size)) 

        #self.draw_visible_text_only(painter)

        self.simpole_draw_text(painter)

        painter.restore()

class PaintButton(PaintLabelBox):
    NO_STATE = 0
    NOW_CLICKED = 1
    NOW_HOVER = 2

    def __init__(self, text=""):
        super().__init__( text)
        self.set_hieght_fit(False)
        self.rect = QRect(50, 50, 100, 50)
        self.state = self.NO_STATE
        self.set_align("center")
        self.nostate_color = QColor(192, 192, 192)
        self.clicked_color = QColor(255, 0, 0)
        self.hover_color = QColor(224, 224, 224)
        self.border_color = QColor(0, 0, 0)
        
        self.border_size = 2

    def check_point_in(self, pos):
        if self.rect.contains(pos):
            return True
        else:
            return False

    def mouse_down(self, fpos):
        pos = QPoint(fpos.x(),fpos.y())

        if self.rect.contains(pos):
            self.state = self.NOW_CLICKED
            return True
        else:
            return False

    def mouse_up(self, fpos):
        pos = QPoint(fpos.x(), fpos.y())
        self.state = self.NO_STATE

    def mouse_hover(self, fpos):
        pos = QPoint(fpos.x(), fpos.y())
        if self.rect.contains(pos):

            if self.NO_STATE == self.state:
                self.state = self.NOW_HOVER
        else:
            self.state = self.NO_STATE

    def set_back_color(self, color):
        self.nostate_color = color

    def set_clicked_back_color(self, color):
        self.clicked_color = color

    def set_hover_back_color(self, color):
        self.hover_color = color
    def set_border_color(self, color):
        self.border_color = color
    def set_border_size(self, size):
        self.border_size = size

    def get_border_size(self):
        return self.border_size


    def draw(self, obj):
        if False == PaintBaseObject.check_rect_in(self.rect):
            return        
        painter = QPainter(obj)
        painter.save()
        painter.setClipRect(PaintBaseObject.widget_area)
        bc = self.border_color
        if 0 == self.border_size:
            bc = self.back_color
        if self.NO_STATE == self.state:
            painter.setPen(QPen(bc, self.border_size))  # 青色の枠線
            painter.setBrush(QBrush(self.nostate_color))  # 赤色の塗りつぶし
        if self.NOW_CLICKED == self.state:
            painter.setPen(QPen(bc, self.border_size))  # 青色の枠線
            painter.setBrush(QBrush(self.clicked_color))  # 赤色の塗りつぶし
        if self.NOW_HOVER == self.state:
            painter.setPen(QPen(bc, self.border_size))  # 青色の枠線
            painter.setBrush(QBrush(self.hover_color))  # 赤色の塗りつぶし

        painter.drawRoundedRect(self.rect, self.font_size/2, self.font_size/2)
        painter.setPen(QPen(self.font_color, self.border_size)) 
        painter.drawText(self.rect, self.get_align(), self.text)
        painter.setPen(QPen(bc, self.border_size))
        
        painter.setBrush(QBrush(Qt.BrushStyle.NoBrush))  # 赤色の塗りつぶし
        painter.drawRoundedRect(self.rect, self.font_size/2, self.font_size/2)
        painter.restore()

class PaintChatTitleBox(PaintBaseObject):
    def __init__(self, title_text):
        self.title = PaintLabelBox(title_text.rstrip())
        self.button = PaintButton("copy")
        

    def mouse_down(self, pos):
        return self.button.mouse_down(pos)

    def mouse_up(self, pos):
        self.button.mouse_up(pos)

    def mouse_hover(self, pos):
        self.button.mouse_hover(pos)

    def set_title_text(self, text):
        self.title.set_text(text)

    def get_title_text(self):
        self.title.get_text()

    def set_font_size(self, size):
        if size < 7:
            size = 7
        self.title.set_font_size(size)
        self.button.set_font_size(size-2)

    def set_title_size(self, width, height):
        self.title.set_size(width, height)
        
        
        self.button.set_size(self.button.width(),
                             height - self.button.get_border()*2)
        
        self.button.set_position(self.title.x() + self.title.width() -
                                 self.button.width() - self.button.get_border(),
                                 self.title.y() + self.button.get_border())

    def set_button_size(self, width, height):
        self.button.set_size(width, height)

    def set_back_color(self, color):
        self.title.set_back_color(color)

    def set_border_color(self, color):
        self.title.set_border_color(color)

    def set_border_size(self, size):
        self.title.set_border_size(size)

    def get_border_size(self):
        return self.title.get_border_size()


    def set_position(self, x, y):
        self.title.set_position(x, y)
        self.button.set_position(x + self.title.width() -
                                 self.button.width() - self.button.get_border(),
                                 y + self.button.get_border())

    def move(self, x, y):
        self.title.move(x, y)
        self.button.move(x, y)

    def height(self):
        return self.title.height()

    def width(self):
        return self.title.width()

    def x(self):
        return self.title.x()

    def y(self):
        return self.title.y()

    def check_point_in(self, pos):
        return self.button.check_point_in(pos)

    def draw(self, obj):
        if False == self.title.check_rect_in():
            return        
        self.title.draw(obj)
        self.button.draw(obj)



class PaintTitelAndContents(PaintBaseObject):
    def __init__(self, title=" ", contents=""):

        self.border_size = 2
        self.back_color = QColor(255, 255, 255)
        self.border_color = QColor(0,0,0)
        self.sepalate_color = QColor(0, 0, 0)
        self.font_size = 15
        self.title = PaintChatTitleBox(title)
        self.contents = PaintLabelBox(contents)
        self.title.set_border_size(0)
        self.contents.set_border_size(0)
        
    def mouse_down(self, pos):
        return self.title.mouse_down(pos)
        

    def mouse_up(self, pos):
        self.title.mouse_up(pos)

    def mouse_hover(self, pos):
        self.title.mouse_hover(pos)

    def set_contents_height_fit(self, fit_flag):
        self.contents.set_hieght_fit(fit_flag)

    def set_title(self, text):
        self.title.set_title_text(text)

    def get_title(self):
        self.title.get_title_text()

    def set_contents(self, text):
        self.contents.set_text(text)

    def get_contents_text(self):
        return self.contents.get_text()

    def append_text(self, text):
        self.contents.append_text(text)

    def delete_contets_last_line(self):
        self.contents.delete_last_line()


    def sef_font_size(self, size):
        self.title.set_font_size(size)
        self.contents.set_font_size(size)
        self.font_size = size
    def get_font_size(self):
        return self.font_size


    def set_back_color(self, color):
        self.back_color = color
        self.title.set_back_color(color)
        self.contents.set_back_color(color)
    def get_back_color(self):
        return self.back_color


    def set_sepalate_color(self, color):
        self.sepalate_color = color
    def get_sepalate_color(self):
        return self.sepalate_color

    def set_border_color(self, color):
        self.border_color = color
    def get_border_color(self):
        return self.border_color


    def set_border_size(self, size):
        self.border_size = size

    def get_border_size(self):
        return self.border_size

    def set_title_font_size(self, size):
        if size < 7:
            size = 7
        self.title.set_font_size(size)

    def set_contents_font_size(self, size):
        if size < 7:
            size = 7
        
        self.contents.set_font_size(size)

    def set_contents_height(self, height):
        self.contents.set_size(self.contents.width(), height)

    def add_contents_height(self, height):
        self.contents.set_size(self.contents.width(),
                               self.contents.height() + height)

    def get_contents_height(self):
        return self.contents.height()

    def get_title_height(self):
        return self.title.height()

    def set_width(self, width):

        self.title.set_title_size(width, self.title.height())
        self.contents.set_size(width, self.contents.height())
        self.contents.set_position(self.title.x(),
                                   self.title.y() + self.title.height())

    def set_position(self, x, y):
        self.title.set_position(x, y)
        self.contents.set_position(x,
                                   y + self.title.height())

    def set_contents_border(self, bsize):
        self.contents.set_border(bsize)

    def get_contents_border(self):
        return self.contents.get_border()

    def move(self, x, y):
        self.title.move(x, y)
        self.contents.move(x, y)

    def height(self):
        return self.title.height() + self.contents.height()

    def width(self):
        return self.title.width()

    def x(self):
        return self.title.x()

    def y(self):
        return self.title.y()

    def get_rect(self):
        return QRect(self.x(), self.y(), self.width(), self.height())

    # Add this method to PaintTitelAndContents
    def set_font_size_for_all_elements(self, new_size):
        self.title.set_font_size(new_size) 
        self.contents.set_font_size(new_size)

    def check_point_in(self, pos):
        return self.title.check_point_in(pos)

    def draw(self, obj):
        if False == PaintBaseObject.check_rect_in(self.get_rect()):
            return
        
        painter = QPainter(obj)        
        painter.save()        
        painter.setClipRect(PaintBaseObject.widget_area)


        
        painter.setPen(QPen(self.get_back_color(), self.get_border_size()))  # 枠線
        
        painter.setBrush(QBrush(self.get_back_color()))  # 塗りつぶし

        painter.drawRoundedRect(self.get_rect(), self.get_font_size()/2, self.get_font_size()/2)
        painter.restore()

        #print("tile witdh", self.title.width())
        #print("contens witdh", self.contents.width())
        #print("title, border", self.title.get_border_size())
        #print("contents, border", self.contents.get_border())
        self.title.draw(obj)
        self.contents.draw(obj)

  
        painter.save()   
        painter.setClipRect(PaintBaseObject.widget_area)
        if 0 != self.get_border_size():
        
            painter.setPen(QPen(self.get_border_color(), self.get_border_size()))  # 枠線
            painter.setBrush(Qt.BrushStyle.NoBrush)  # 塗りつぶし
    #
            painter.drawRoundedRect(self.get_rect(), self.get_font_size()/2, self.get_font_size()/2)



        painter.setPen(QPen(self.get_sepalate_color(), self.get_border_size()))  # 枠線
        painter.setBrush(QBrush(self.get_sepalate_color()))  # 塗りつぶし
        painter.drawLine(QPoint(self.contents.x(), self.contents.y() ),
                         QPoint(self.contents.x() + self.contents.width(), self.contents.y() ))
        painter.restore()   

class PaintChatNode(PaintBaseObject):
    NOMAL_BLOCK = 0
    PROGRAM_BLOCK = 1
    now_thinking = False
    def __init__(self,
                 title=" ",
                 contents=" "):
        self.main = PaintTitelAndContents(title)
        self.main.set_border_size(2)
        self.blok_type = PaintChatNode.NOMAL_BLOCK
        self.main.set_contents_height_fit(False)
        self.contents_text = ""
        self.current_font_size = 15 # Default initial font size for new nodes
        self.contents = []

        # 差分更新用の状態変数
        self._is_streaming = False
        self._streaming_buffer = ""
        self._streaming_program_name = ""
        self._last_content_was_code_title_during_streaming = False # ストリーミング中にコードタイトルが最後だったか

        # プログラム名の状態変数
        self._program_name_in_progress = False
        self._program_name_buffer = ""
        self.pre_now_thinking = False
        # Apply this default to the main component and its children
        self.main.set_font_size_for_all_elements(self.current_font_size)
        self.extract_code_block(contents)

    def set_font_size_for_all_elements(self, new_size):
        self.current_font_size = new_size # Keep track

        self.main.set_font_size_for_all_elements(new_size) # Propagate to main PaintTitelAndContents

        for content_item in self.contents:
            if isinstance(content_item, PaintTitelAndContents):
                content_item.set_font_size_for_all_elements(new_size)
            elif isinstance(content_item, PaintLabelBox): # Includes PaintButton
                content_item.set_font_size(new_size)
        self.__fit_height() # Recalculate layout

    def mouse_down(self, pos):

        if self.main.mouse_down(pos):
            pyperclip.copy(self.contents_text)
#            print("self.main.get_text()", self.contents_text)

        for obj in self.contents:
            if PaintTitelAndContents is type(obj):
                if obj.mouse_down(pos):
                    pyperclip.copy(obj.get_contents_text())
#                    print("obj.get_text()", obj.get_contents_text())
            #copy

    def mouse_up(self, pos):
        self.main.mouse_up(pos)
        for obj in self.contents:
            if PaintTitelAndContents is type(obj):
                obj.mouse_up(pos)

    def mouse_hover(self, pos):
        self.main.mouse_hover(pos)

    def set_title(self, text):
        self.main.set_title(text)

    def set_contents(self, text):
        #self.contents = []
        # 差分更新状態をリセット
        self._is_streaming = False
        self._streaming_buffer = ""
        self._streaming_program_name = ""
        self.blok_type = PaintChatNode.NOMAL_BLOCK # 全文処理開始時はノーマル

        self.extract_code_block(text)
        self.main.set_contents(text)

    def append_text(self, text_segment):
        start_time = time.perf_counter()


        self.contents_text += text_segment # 全文を更新
        self._extract_and_append_incremental(text_segment) # 差分処理
        self.__fit_height() # 追記の都度、高さ調整

        end_time = time.perf_counter()
        processing_time = (end_time - start_time) * 1000 # ミリ秒に変換

    def set_position(self, x, y):
        self.main.set_position(x, y)
        for obj in self.contents:
            if PaintTitelAndContents is type(obj):
                self.__set_titelandcontents_width_and_position(obj)
            else:
                self.__update_label_position(obj)
        self.__fit_height()

    def __update_label_position(self, label):
        label.set_position(self.x() + self.main.get_border_size(),
                           self.y() + self.main.get_border_size())
        
    def __set_label_width_and_position(self, label):
        label.set_width(self.width() - self.main.get_border_size()*2)
        # x位置の設定 yは後で合わせる
        label.set_position(self.x() + self.main.get_border_size(),
                           self.y() + self.main.get_border_size())

    def __set_titelandcontents_width_and_position(self, tc):
        tc.set_width(self.width() - self.main.get_border_size()*4)
        # x位置の設定 yは後で合わせる
        tc.set_position(self.x() + self.main.get_border_size()*2,
                        self.y() + self.main.get_border_size())

    def set_width(self, width):
        self.main.set_width(width)
        for obj in self.contents:
            if PaintTitelAndContents is type(obj):
                self.__set_titelandcontents_width_and_position(obj)
            else:
                self.__set_label_width_and_position(obj)
        self.__fit_height()

    def set_contents_height(self, height):
        self.main.set_contents_height(height)

    def height(self):
        return self.main.height()

    def width(self):
        return self.main.width()

    def x(self):
        return self.main.x()

    def y(self):
        return self.main.y()

    def append_contents_object(self, obj, contents_buf = None):
        if None is contents_buf:
            contents_buf = []
            contents_buf.append(obj)
        else:
            contents_buf.append(obj)
        
        if 0 == len(contents_buf):
            obj.set_position(self.main.x(), self.main.get_title_height())
        self.main.add_contents_height(obj.height())

    def _prepare_content_object(self, obj):
        # フォント設定
        if hasattr(obj, 'set_font_size_for_all_elements'):
            obj.set_font_size_for_all_elements(self.current_font_size)
        elif hasattr(obj, 'set_font_size'):
            obj.set_font_size(self.current_font_size)
        # 幅とX位置設定 (Y位置は __fit_height で調整)
        if isinstance(obj, PaintTitelAndContents):
            self.__set_titelandcontents_width_and_position(obj)
        elif isinstance(obj, PaintLabelBox):
            self.__set_label_width_and_position(obj)
        return obj
    
    def _extract_and_append_incremental(self, appended_text_segment):
        if not self._is_streaming:
            self._is_streaming = True
        self._streaming_buffer = "" # 処理するので一旦クリア
        #行の途中で終わっているときその分を先頭に追加
        if isinstance(self.contents[-1], PaintTitelAndContents):
            now_buf = self.contents[-1].get_contents_text().split('\n')#これまで追加されたテキスト
        elif isinstance(self.contents[-1], PaintLabelBox):
            now_buf = self.contents[-1].get_text().split('\n')#これまで追加されたテキスト
        if 0 < len(now_buf):
            if not now_buf[-1].endswith("\n"):
                self._streaming_buffer += now_buf[-1]
            
        text_to_process = self._streaming_buffer + appended_text_segment

        #改行コードで終わっている。
        lines = text_to_process.split('\n')
        new_buf =  appended_text_segment.split('\n')#送られてきた元のデータの初めの行を使いするのに使う。
        for i ,line in enumerate(lines):
            line = line.rstrip()
            if False == PaintChatNode.now_thinking:
                if self.pre_now_thinking != PaintChatNode.now_thinking:
                    label = PaintLabelBox("")
                    self._prepare_content_object(label)
                    label.set_border(0)
                    #label.set_span(26)
                    self.append_contents_object(label, self.contents)                    
                self.pre_now_thinking = PaintChatNode.now_thinking

                if PaintChatNode.NOMAL_BLOCK == self.blok_type:
                # nomal blockの時
                    # 正規表現でコードブロックを検索
                    match = re.search(r'^```(.*?)', line, re.DOTALL)
                    if match:

                        self.blok_type = self.PROGRAM_BLOCK
                        program_name = line[3:]
                        if len(lines) - 1 == i:
                            if "" == program_name:
                                self._program_name_in_progress = True
                                self._program_name_buffer=""
                                continue
                        program = PaintTitelAndContents(program_name, "")
                        # program = program.get_main_box()
                        self._prepare_content_object(program)
                        self.append_contents_object(program, self.contents)
                        continue

                else:

                    if self._program_name_in_progress:
                        # ストリーミング中にコードタイトルが最後だった場合
                        # ここでプログラム名を設定
                        self._program_name_buffer += line

                        if 0 == i and 1 == len(lines):


                            if appended_text_segment.endswith("\n") or appended_text_segment.endswith("\r\n"):
                                pass
                            else:

                                continue

                        program = PaintTitelAndContents(self._program_name_buffer, "")
                        # program = program.get_main_box()
                        self._prepare_content_object(program)
                        self.append_contents_object(program, self.contents)                    
                        self._program_name_in_progress = False
                        self._program_name_buffer = ""
                        continue
                    # purogram blockの時

                    match = re.search(r'```$', line, re.DOTALL)  # 正規表現でコードブロックを検索

                    if match:
                        if  "`" in self._streaming_buffer:
                            if isinstance(self.contents[-1], PaintTitelAndContents):
                                self.contents[-1].delete_contets_last_line()
                            elif isinstance(self.contents[-1], PaintLabelBox):
                                self.contents[-1].delete_last_line()
                        label = PaintLabelBox("")
                        self._prepare_content_object(label)
                        label.set_border(0)
                        #label.set_span(26)
                        self.append_contents_object(label, self.contents)

                        self.blok_type = PaintChatNode.NOMAL_BLOCK
                        continue
            else:
                if self.pre_now_thinking != PaintChatNode.now_thinking:
                    # 思考中状態が変化したとき、ノーマルブロックに戻す
                    print("PaintChatNode.now_thinking",PaintChatNode.now_thinking)
                    self.blok_type = PaintChatNode.NOMAL_BLOCK
                    self.pre_now_thinking = PaintChatNode.now_thinking
                    program = PaintTitelAndContents("thinking", "")
                    # program = program.get_main_box()
                    self._prepare_content_object(program)
                    self.append_contents_object(program, self.contents)                    
            #text_buf += line + "\n"
            if None is self.contents or 0 == len(self.contents):
                self.blok_type = self.NOMAL_BLOCK
                self.contents=[]
                # ここまでのテキストデータをラベルとして追加
                label = PaintLabelBox("")
                self._prepare_content_object(label)
                label.set_border(0)
                #label.set_span(26)
                self.append_contents_object(label, self.contents)
                # 初期化
            
            if i == len(lines) - 1:
                if 0 == i:
                    

                    self.contents[-1].append_text(new_buf[0])
                else:
                    self.contents[-1].append_text(line)
                
                pass
            else:
                if 0 == i:
                    

                         
                    self.contents[-1].append_text(new_buf[0] + "\n")
                else:
                    self.contents[-1].append_text(line + "\n")
                
            self._prepare_content_object(self.contents)
        self.__fit_height()

    def extract_code_block(self, text):  # コードブロックの抽出
        contents_buf = []
        self.blok_type = self.NOMAL_BLOCK
        self.contents_text = text # Store the original full text for copy-paste
        lines = text.split("\n")
        program_name = ""
        text_buf = ""
        for line in lines:
            
            line = line.rstrip()
            if self.NOMAL_BLOCK == self.blok_type:
                # nomal blockの時
                # 正規表現でコードブロックを検索
                match = re.search(r'^```(.*?)', line, re.DOTALL)
                if match:
                    self.blok_type = self.PROGRAM_BLOCK
                    program_name = line[3:]
                    # ここまでのテキストデータをラベルとして追加
                    text_buf = text_buf.rstrip()
                    label = PaintLabelBox(text_buf)
                    label.set_font_size(self.current_font_size) # Apply current node font size
                    label.set_border(0)
                    #label.set_span(26)
                    self.__set_label_width_and_position(label)
                    self.append_contents_object(label, contents_buf)
                    # 初期化
                    self.last_text = text_buf
                    
                    text_buf = ""
                    continue
            else:
                # purogram blockの時
                match = re.search(r'```$', line, re.DOTALL)  # 正規表現でコードブロックを検索

                if match:
                    self.blok_type = self.NOMAL_BLOCK
                    # ここまでのテキストデータをプログラムとして追加
                    text_buf = text_buf.rstrip()
                    program = PaintTitelAndContents(program_name, text_buf)
                    # program = program.get_main_box()
                    program.set_font_size_for_all_elements(self.current_font_size) # Apply current node font size
                    self.__set_titelandcontents_width_and_position(program)
                    self.append_contents_object(program, contents_buf)
                    # 初期化
                    program_name = ""
                    self.last_text = text_buf
                    text_buf = ""
                    continue
            text_buf += line + "\n"

        if self.PROGRAM_BLOCK == self.blok_type:
            # プログラムブロックを終了する前に終了した
            # program block
            text_buf = text_buf.rstrip()
            program = PaintTitelAndContents(program_name, text_buf)
            program.set_font_size_for_all_elements(self.current_font_size) # Apply current node font size
            self.__set_titelandcontents_width_and_position(program)

            self.append_contents_object(program, contents_buf)
            self.blok_type = self.NOMAL_BLOCK
        else:
            # ノーマルブロックの状態で終了した。
            # nomal block
            text_buf = text_buf.rstrip()
            label = PaintLabelBox(text_buf)
            label.set_font_size(self.current_font_size) # Apply current node font size
            label.set_border(0)
            #label.set_span(26)
            self.__set_label_width_and_position(label)

            self.append_contents_object(label, contents_buf)
        self.contents = contents_buf
        self.last_text = text_buf
        self.__fit_height()

    def __fit_height(self):
        h = self.main.get_title_height() # タイトルの高さ
        count = 0
        for obj in self.contents:
            count += 1
            obj.set_position(obj.x(),
                             self.y() + h +
                             self.main.get_contents_border() * count)

            h += obj.height() # 各コンテンツの高さを加算

        self.set_contents_height(h-self.main.get_title_height() +
                                 self.main.get_contents_border()*count*2)


    def draw(self, obj):

        painter = QPainter(obj)        
        painter.save()        
        painter.setClipRect(PaintBaseObject.widget_area)


        
        painter.setPen(QPen(self.main.get_back_color(), self.main.get_border_size()))  # 枠線
        
        painter.setBrush(QBrush(self.main.get_back_color()))  # 塗りつぶし

        painter.drawRoundedRect(self.main.get_rect(), self.main.get_font_size()/2, self.main.get_font_size()/2)
        painter.restore()
        #self.main.set_border_size(0)

        self.main.draw(obj)
        for pobj in self.contents:
            pobj.draw(obj)

        #self.main.set_border_size(2)
        painter.save()   
        painter.setClipRect(PaintBaseObject.widget_area)
        if 0 != self.main.get_border_size():
        
            painter.setPen(QPen(self.main.get_border_color(), self.main.get_border_size()))  # 枠線
            painter.setBrush(Qt.BrushStyle.NoBrush)  # 塗りつぶし
    #
            painter.drawRoundedRect(self.main.get_rect(), self.main.get_font_size()/2, self.main.get_font_size()/2)



        painter.setPen(QPen(self.main.get_sepalate_color(), self.main.get_border_size()))  # 枠線
        painter.setBrush(QBrush(self.main.get_sepalate_color()))  # 塗りつぶし
        painter.drawLine(QPoint(self.main.contents.x(), self.main.contents.y() ),
                         QPoint(self.main.contents.x() + self.main.contents.width(), self.main.contents.y() ))
        painter.restore()

    @classmethod
    def set_now_thinking(cls, flag):
        cls.now_thinking = flag



class PaintChatThread(PaintBaseObject):
    def __init__(self):
        self.nodes = []
        self.draw_area = QRect(0, 0, 100, 1000)
        self.draw_start_index = 0
        self.node_space = 10

    def mouse_down(self, pos):
        pos = QPoint(self.draw_area.x() + pos.x(),
                     self.draw_area.y() + pos.y())
        for node in self.nodes:
            node.mouse_down(pos)

    def mouse_up(self, pos):
        pos = QPoint(self.draw_area.x() + pos.x(),
                     self.draw_area.y() + pos.y())
        for node in self.nodes:
            node.mouse_up(pos)

    def mouse_hover(self, pos):
        pos = QPoint(self.draw_area.x() + pos.x(),
                     self.draw_area.y() + pos.y())
        for node in self.nodes:
            node.mouse_hover(pos)

    def append(self, node):
        self.nodes.append(node)
        if 1 < len(self.nodes):
#            self.nodes[-1].set_position(
#                self.nodes[-2].x(),
#                self.nodes[-2].y() + self.nodes[-2].height() + self.node_space * (len(self.nodes)-1))
            self.nodes[-1].set_position(
                self.nodes[-2].x(),
                self.nodes[-2].y() + self.nodes[-2].height() + self.node_space)
            
    def append_node(self, title, contents):
        node = PaintChatNode(title, contents)

        if 0 < len(self.nodes):
            n_bottom = self.nodes[-1].y() + self.nodes[-1].height()
            da_bottom = self.draw_area_y() + self.draw_area_height()
            width = self.width()
            node.set_width(width)
        else:
            
            # ノードがないときはself.width()だと0が返ってきてしまう
            width = self.draw_area.width()
            node.set_width(width)
            pass
        self.append(node)
        if 1 < len(self.nodes):

            if n_bottom == da_bottom:
                self.set_draw_area_y(self.nodes[-1].y() + self.nodes[-1].height() - self.draw_area_height())
            elif n_bottom <= da_bottom:
                post_bottom = self.draw_area_y() + self.draw_area_height()
                if da_bottom <= post_bottom:
                    self.set_draw_area_y(self.nodes[-1].y() + self.nodes[-1].height() - self.draw_area_height())
    
    def append_text(self, text):
#        for frame in inspect.stack():
#            print(frame.filename, frame.lineno, frame.function)


        pre_draw_bottom = self.draw_area_y() + self.draw_area_height()
        pre_contentts_height = self.height()
        if 0 < len(self.nodes):
            self.nodes[-1].append_text(text)

        self.__set_draw_start_index()

        if pre_draw_bottom == pre_contentts_height:
            self.set_draw_area_y(self.height()-self.draw_area_height())
        elif pre_contentts_height <= pre_draw_bottom:
            post_bottom = self.draw_area_y() + self.draw_area_height()
            if pre_draw_bottom <= post_bottom:
                self.set_draw_area_y(self.height()-self.draw_area_height())
    
    def set_last_node_text(self, text):
        pre_draw_bottom = self.draw_area_y() + self.draw_area_height()
        pre_contentts_height = self.height()
        if 0 < len(self.nodes):
            self.nodes[-1].set_contents(text)
        self.__set_draw_start_index()
        if pre_draw_bottom == pre_contentts_height:
            self.set_draw_area_y(self.height()-self.draw_area_height())

    def height(self):
        if 0 < len(self.nodes):
            return self.nodes[-1].y() + self.nodes[-1].height()
        else:
            return 0

    def width(self):
        if 0 < len(self.nodes):
            return self.nodes[-1].width()
        else:
            return 0

    def draw_area_height(self):
        return self.draw_area.height()

    def draw_area_y(self):
        return self.draw_area.y()

    def set_draw_area_y(self, y):

        self.set_draw_area(self.draw_area.x(),
                           y,
                           self.draw_area.width(),
                           self.draw_area.height())

    def set_draw_area(self, x, y, width, height):
        pre_y = self.draw_area.y()
        if y < 0:
            y = 0
        self.draw_area.setRect(x, y, width, height)
        reverse = True
        if pre_y < self.draw_area.y():
            reverse = False
        self.__set_draw_start_index(reverse)

    def set_width(self, w):
        y_deff_buf = -1

        y_buf = -1
        if 0 < len(self.nodes):
            change_flag = True
            for i in range(len(self.nodes)):
                # 一番上の　描画　ノードとの関係を固定
                if 0 == i:
                    y_deff_buf = self.draw_area.y() - self.nodes[i].y()
                    change_flag = True
                self.nodes[i].set_width(w)
                if 0 < i:
                    self.nodes[i].set_position(
                        self.nodes[i - 1].x(),
                        self.nodes[i - 1].y() + self.nodes[i-1].height() + self.node_space)
                    # 一番上の　描画　ノードとの関係を固定
                    if 0 <= self.draw_area.y() - self.nodes[i].y():
                        y_deff_buf = self.draw_area.y() - self.nodes[i].y() 
                        change_flag = True
                if change_flag:
                    y_buf = self.nodes[i].y()
                change_flag = False
            # 描画範囲を設定
            if self.nodes[-1].y()+self.nodes[-1].height() - self.draw_area.height() < y_buf + y_deff_buf:
                y_deff_buf = (self.nodes[-1].y()+self.nodes[-1].height() - self.draw_area.height())
                y_buf = 0
        if  y_buf + y_deff_buf < 0:
            y_buf = 0
            y_deff_buf = 0
        self.draw_area.setRect(
            self.draw_area.x(),
            y_buf + y_deff_buf,
            w,
            self.draw_area.height())
        
    def _reset_nodes_position(self):
        self.set_width(self.width())

    def move_vertical(self, y):
        self.draw_area.setRect(
            self.draw_area.x(),
            self.draw_area.y() + y,
            self.draw_area.width(),
            self.draw_area.height())

        self.__set_draw_start_index(y < 0)

    def __set_draw_start_index(self, reverse=False):
        """
        描画エリア内に表示されるべき最初のノードのインデックスを決定する役割を担っている
        """
        # ノードリストが存在する場合のみ処理を行う
        if 0 < len(self.nodes):
            # 現在の描画開始インデックスがノードリストの範囲外であれば、最後のノードのインデックスに調整する
            if len(self.nodes) <= self.draw_start_index:
                self.draw_start_index = len(self.nodes) -1
            # 逆方向（上方向へスクロールなど）の場合の処理
            if reverse:
                # 現在の描画開始インデックスから逆順にノードをチェック
                for i in range(self.draw_start_index, -1, -1):
                    # ノードiの下端が描画エリアの上端よりも下にあるか（つまり、ノードiが描画エリア内またはエリアより下にあるか）
                    if self.draw_area.y() < self.nodes[i].y() +self.nodes[i].height():
                        # ノードiの上端が描画エリアの下端よりも上にあるか（つまり、ノードiが描画エリア内に部分的にでも表示されているか）
                        if self.nodes[i].y() < self.draw_area.y() + self.draw_area.height():
                            # 条件を満たせば、このノードを描画開始インデックスとする
                            self.draw_start_index = i

                    # ノードiの下端が描画エリアの上端よりも上にある場合（つまり、ノードiが完全に描画エリアより上にある場合）
                    # それより前のノードも描画エリア外なので、ループを抜ける
                    if self.nodes[i].y() + self.nodes[i].height() < self.draw_area.y():
                        break
            # 正方向（下方向へスクロールなど）の場合の処理                    
            else:
                # 現在の描画開始インデックスから順方向にノードをチェック
                for i in range(self.draw_start_index, len(self.nodes)):
                    # ノードiの下端が描画エリアの上端よりも下にあるか
                    if self.draw_area.y() < self.nodes[i].y() + self.nodes[i].height():
                        # ノードiの上端が描画エリアの下端よりも上にあるか
                        if self.nodes[i].y() < self.draw_area.y() + self.draw_area.height():
                             # 条件を満たせば、このノードを描画開始インデックスとし、処理を終了
                            self.draw_start_index = i
                            return

    def draw(self, obj):
        if 0 < len(self.nodes):            
            #print("draw len(self.nodes)",len(self.nodes))
            # 現在の描画開始インデックスから順方向にノードをチェック
            for i in range(self.draw_start_index, len(self.nodes)):
                if self.draw_area.y() < self.nodes[i].y() + self.nodes[i].height():
                    if self.nodes[i].y() < self.draw_area.y() + self.draw_area.height():
                        # draw area内のノードだけ描画
                        pre_x = self.nodes[i].x()
                        pre_y = self.nodes[i].y()
                        self.nodes[i].set_position(self.nodes[i].x()-self.draw_area.x(),
                                                   self.nodes[i].y()-self.draw_area.y())
                        self.nodes[i].draw(obj)
                        self.nodes[i].set_position(pre_x,
                                                   pre_y)

                if self.draw_area.y() + self.draw_area.height() < self.nodes[i].y():
                    return

    def get_draw_bottom(self):

        return self.draw_area.x() + self.draw_area.height()

    def clear_all(self):
        self.nodes = []

class PaintArrowSlider():
    NO_STATE = 0
    CLICK_UP = 1
    CLICK_DOWN = 2
    CLICK_SLIDER = 3
    CLICK_SLIDER_UP = 4
    CLICK_SLIDER_DOWN = 5
    def __init__(self):
        self.up_button = PaintButton("▲")
        self.down_button = PaintButton("▼")
        self.slider = PaintButton(" ")
        self.up_button.set_border_size(0)
        self.down_button.set_border_size(0)
        self.slider.set_border_size(0)
        self.up_button.set_border_color(QColor(128,128,128))
        self.down_button.set_border_color(QColor(128,128,128))
        self.slider.set_border_color(QColor(128,128,128))
        self.slider.set_hieght_fit(False)
        self.state = self.NO_STATE
        self.slider_min = 10
        self.rect = QRect(0, 0, 10, 100)
        self.border_size = 0
        self.y_position_ratio = 1
        self.slider_height_ratio = 1
        self.set_up_down_button_size(30, 30)
        self.slider.set_width(30)
        self.set_slider_height(1)
        self.set_slider_position(0)
        self.pre_mouse_position = QPoint(0, 0)
        self.slider.set_clicked_back_color(QColor(224,224,224))

    def x(self):
        return self.up_button.x()

    def y(self):
        return self.up_button.y()

    def width(self):
        return self.up_button.width()

    def height(self):
        return self.rect.height()

    def set_up_down_button_size(self, width, height):
        now_height = self.height()

        self.rect = QRect(self.rect.x(),
                          self.rect.y(),
                          width,
                          self.rect.height())
        self.up_button.set_size(width, height)
        self.down_button.set_size(width, height)
        if now_height < height * 3:
            now_height = height*3

        self.set_height(now_height)

    def set_slider_position(self, pos_ratio):
        if 1 < pos_ratio:
            pos_ratio = 1
        if pos_ratio < 0:
            pos_ratio = 0
        self.y_position_ratio = pos_ratio

        self.slider.set_position(
            self.slider.x(),
            self.up_button.height() + (self.down_button.y() -
                                       (self.up_button.y() +
                                        self.up_button.height() +
                                        self.slider.height()))
            * self.y_position_ratio)

    def set_position(self, x, y):
        self.up_button.set_position(x, y)
        # self.slider.set_position(x, y)
        self.down_button.set_position(
            x,
            self.rect.height() - self.down_button.height())
        self.slider.set_position(x, y)
        self.set_slider_position(self.y_position_ratio)
        self.rect = QRect(x, y, self.rect.width(), self.rect.height())

    def mouse_down(self, pos):
        pos = QPoint(pos.x(),pos.y())
       

        if self.up_button.mouse_down(pos):
            self.state = self.CLICK_UP
        elif self.down_button.mouse_down(pos):
            self.state = self.CLICK_DOWN
        elif self.slider.mouse_down(pos):
            self.state = self.CLICK_SLIDER
            self.pre_mouse_position = pos
        elif self.rect.contains(pos):
            if pos.y() < self.slider.y():
                self.state = self.CLICK_SLIDER_UP
            elif self.slider.y() + self.slider.height() < pos.y():
                self.state = self.CLICK_SLIDER_DOWN
        return self.state
    
    def mouse_up(self, pos):
        self.state = self.NO_STATE
        self.up_button.mouse_up(pos)
        self.down_button.mouse_up(pos)
        self.slider.mouse_up(pos)

    def mouse_hover(self, pos):
        self.up_button.mouse_hover(pos)
        self.down_button.mouse_hover(pos)
        self.slider.mouse_hover(pos)

    def mouse_move(self, pos):
        vm = QPoint(int(pos.x() - self.pre_mouse_position.x()),
                    int(pos.y() - self.pre_mouse_position.y()))
        if self.state == self.CLICK_SLIDER:
            if vm.y() < 0:
                if self.up_button.y() + self.up_button.height() <\
                      self.slider.y() + vm.y():
                    self.slider.set_position(
                        self.slider.x(),
                        self.slider.y() + vm.y())
                else:
                    self.slider.set_position(
                        self.slider.x(),
                        self.up_button.y() + self.up_button.height())
            else:
                if self.slider.y() + self.slider.height() + vm.y() <\
                      self.down_button.y():
                    self.slider.set_position(
                        self.slider.x(),
                        self.slider.y() + vm.y())
                else:
                    self.slider.set_position(
                        self.slider.x(),
                        self.down_button.y()-self.slider.height())
            self.pre_mouse_position = pos

            buf = self.slider.y()-(self.up_button.y()+self.up_button.height() )
            buf2 = (self.down_button.y()  -
                    (self.slider.height() +
                     self.up_button.y() +
                     self.up_button.height()))
            if buf2 != 0:
                self.y_position_ratio = (
                    buf/
                    (self.down_button.y()  -
                        (self.slider.height() +
                         self.up_button.y() +
                         self.up_button.height()))
                    )
            else:
                self.y_position_ratio = 0
            

            return vm

    def get_state(self):
        return self.state
    
    def set_width(self, width):
        self.rect = QRect(self.rect.x(), self.rect.y(),
                          width, self.rect.height())
        self.up_button.set_size(width, self.up_button.height())
        self.down_button.set_size(width, self.down_button.height())
        self.slider.set_size(width, self.slider.height())

    def set_height(self, height):
        self.rect = QRect(self.rect.x(), self.rect.y(),
                          self.rect.width(), height)
        ratio = self.get_slider_ratio()
        self.down_button.set_position(self.down_button.x(),
                                      height-self.down_button.height())
        slider_area_height = self.down_button.y() - (self.up_button.height() + self.up_button.y())
        self.slider.set_size(self.slider.width(), int(slider_area_height*ratio))

        self.set_slider_position(self.y_position_ratio)

    def set_rect(self, x , y, width, height):
        self.set_position(x, y)
        self.set_width(width)
        self.set_height(height)

    def get_rect(self):
        return self.rect

    def get_slider_position_ratio(self):
        return self.y_position_ratio

    def get_slider_ratio(self):
        s = self.up_button.y() + self.up_button.height() - self.down_button.y()
        
        return s / self.slider.height()

    def set_slider_height(self, ratio):
        if 1 <= ratio:
            ratio = 1
        s = self.down_button.y() - (self.up_button.y() + self.up_button.height())
        s = s * ratio
        self.slider.set_size(self.slider.width(), int(s))

        if int(s) < self.slider_min:
            self.slider.set_size(self.slider.width(), self.slider_min)
        self.slider_height_ratio = ratio

    def __draw_back(self, obj):
        # スライダー部分の背景
        painter = QPainter(obj)
        painter.setPen(QPen(QColor(128, 128, 128), self.border_size))  # 枠線
        painter.setBrush(QBrush(QColor(128, 128, 128)))  # 塗りつぶし

        rect = QRect(
            self.up_button.x() + 1,
            self.up_button.y()+self.up_button.height(),
            self.up_button.width() - 4,
            self.down_button.y() - (self.up_button.y() + self.up_button.height()))
        # ボタン類の描画
        painter.drawRect(rect)

    def draw(self, obj):
        self.__draw_back(obj)
        self.up_button.draw(obj)
        self.down_button.draw(obj)
        self.slider.draw(obj)


class ChatPaintWidget(QWidget):
    def __init__(self):
        self.is_drawing = False # draw処理中かどうかを示すフラグ        
        super().__init__()
        self.setWindowTitle("Graphics Text with Size and Newline - Debug Version")

        self.font = QFont("Arial", 50)
        self.name = QLabel("")

        self.name.setMaximumWidth(1500)

        self.layout = QVBoxLayout(self)
        self.layout.addWidget(self.name)
        self.setLayout(self.layout)
        self.chat_thread = PaintChatThread()
        self.slider = PaintArrowSlider()
        self.update_font_size(20)
        

    def paintEvent(self, event):
        start_time = time.perf_counter()
        if not self.is_drawing:
            self.is_drawing = True
            try:
                self.chat_thread.draw(self)
                self.slider.draw(self)
            finally:
                self.is_drawing = False
        end_time = time.perf_counter()
        processing_time = (end_time - start_time) * 1000 # ミリ秒に変換
    
    def __page_up(self, deff):
        self.chat_thread.move_vertical(-deff)
        if self.chat_thread.draw_area_y() < 0:
            self.chat_thread.set_draw_area_y(0)
        self.slider.set_slider_position(self.chat_thread.draw_area_y()/(self.chat_thread.height() - self.chat_thread.draw_area_height()))

    def __page_down(self, deff):
        self.chat_thread.move_vertical(deff)
        if self.chat_thread.height() < self.chat_thread.draw_area_y() + self.chat_thread.draw_area_height():
            self.chat_thread.set_draw_area_y(
                self.chat_thread.height() - self.chat_thread.draw_area_height())
        self.slider.set_slider_position(self.chat_thread.draw_area_y()/(self.chat_thread.height() - self.chat_thread.draw_area_height()))

    def mousePressEvent(self, event: QMouseEvent):

        self.chat_thread.mouse_down(event.position())
        res = self.slider.mouse_down(event.position())

        dh = self.chat_thread.draw_area_height()

        if res == self.slider.CLICK_UP:
            self.__page_up(int(dh/10))

        elif res == self.slider.CLICK_DOWN:
            self.__page_down(int(dh/10))

        elif res == self.slider.CLICK_SLIDER_UP:
            self.__page_up(int(dh/10*9))

        elif res == self.slider.CLICK_SLIDER_DOWN:
            self.__page_down(int(dh/10*9))

        self.chat_thread.height()
        self.chat_thread.get_draw_bottom()
        self.update()

    def mouseReleaseEvent(self, event: QMouseEvent):
        self.chat_thread.mouse_up(event.position())
        self.slider.mouse_up(event.position())
        self.update()

    def mouseMoveEvent(self, event: QMouseEvent):
        self.chat_thread.mouse_hover(event.position())
        self.slider.mouse_hover(event.position())
        self.slider.mouse_move(event.position())
        res = self.slider.get_state()

        if res == self.slider.CLICK_SLIDER:

            pr = self.slider.get_slider_position_ratio()

            self.chat_thread.set_draw_area_y(int((self.chat_thread.height() - self.chat_thread.draw_area_height())*pr))
        self.update()

    def keyPressEvent(self, event: QKeyEvent):
        key = event.key()
        dh = self.chat_thread.draw_area_height()

        if key == Qt.Key_PageUp:
            self.__page_up(int(dh/10*9))
        elif key == Qt.Key_PageDown:
            self.__page_down(int(dh/10*9))
        elif key == Qt.Key_Up:
            self.__page_up(int(dh/10))
            # 上矢印キーが押されたときの処理
        elif key == Qt.Key_Down:
            self.__page_down(int(dh/10))

        self.chat_thread.height()
        self.chat_thread.get_draw_bottom()
        self.update()

    def wheelEvent(self, event: QWheelEvent):
        # event.angleDelta().y() は、垂直方向の回転量を返します。
        # 正の値は上方向への回転、負の値は下方向への回転を示します。
        delta = event.angleDelta().y()
        dh = self.chat_thread.draw_area_height()

        # 回転量に応じて処理を行います。
        if delta > 0:
            # 上方向への回転時の処理
            self.__page_up(int(dh/10))
        else:

            self.__page_down(int(dh/10))
            # 下方向への回転時の処理
        self.chat_thread.height()
        self.chat_thread.get_draw_bottom()
        self.update()

    def update_font_size(self, font_size=None):
        if font_size is None:
            # Fallback to a default if no font_size is provided
            font_size = 15 # Default font size

        self.font.setPointSize(font_size) # For the widget itself, if needed
        #self.chat_thread.set_font_size(font_size)
        # Propagate to all nodes
        if hasattr(self, 'chat_thread') and hasattr(self.chat_thread, 'nodes'):
            for node in self.chat_thread.nodes:
                if hasattr(node, 'set_font_size_for_all_elements'):
                    node.set_font_size_for_all_elements(font_size)
        self.chat_thread._reset_nodes_position()
        self.__update_slider()
        self.update()

    def __update_slider(self):
        self.slider.set_rect(self.width()-self.slider.width(), 0, self.slider.width(), self.height())
        
        if (0 == self.chat_thread.height()):
            self.slider.set_slider_height(0)
        else:
            self.slider.set_slider_height(self.chat_thread.draw_area_height()/self.chat_thread.height())
        self.slider.get_slider_position_ratio()
        if (self.chat_thread.height() - self.chat_thread.draw_area_height()) <=0:
            self.slider.set_slider_position(0)
        else:            
            self.slider.set_slider_position(self.chat_thread.draw_area_y()/max(1,(self.chat_thread.height() - self.chat_thread.draw_area_height())))
        self.slider.get_slider_ratio()

    def resizeEvent(self, event):
        da_y = self.chat_thread.draw_area_y()
        if self.chat_thread.height() < self.height():
            da_y = 0
        else:
            if self.chat_thread.height() <= da_y + self.height():
                da_y = self.chat_thread.height() - self.height()
            elif self.chat_thread.height() <= da_y + self.chat_thread.draw_area_height():
                da_y = self.chat_thread.height() - self.height()
        self.chat_thread.height()

        self.chat_thread.set_draw_area(
            -10, da_y, self.width()-self.slider.width() - 10, self.height())
        if self.chat_thread.width() != self.width()-self.slider.width()-20:
            self.chat_thread.set_width(self.width()-self.slider.width()-20)
        
#        PaintBaseObject.set_widget_area(QRect(self.x(), self.y(), self.width(), self.height()))
        PaintBaseObject.set_widget_area(QRect(0, 0, self.width(), self.height()))
        self.__update_slider()
        self.update()

    def __resize(self):
        self.resizeEvent(None) # QResizeEvent を渡す必要はない
       
    def append_node(self, title, text):

        self.chat_thread.append_node(title, text)
        self.__resize()

    def append_text(self, text):
        # 最後のノードにテキストを追記
        self.chat_thread.append_text(text)
        if self.is_drawing:
            return 
        self.__resize() # テキスト追加で高さが変わる可能性があるので再計算

    def set_last_node_text(self, text):
        # 最後のノードのテキストを置き換え
        self.chat_thread.set_last_node_text(text)
        while self.is_drawing:
            time.sleep(0.1)
        self.__resize() # テキスト置換で高さが変わる可能性があるので再計算

    def new_streaming_node(self, title):
        # ストリーミング表示用の新しい空ノードを追加
        self.chat_thread.append_node(title, "") # 初期テキストは空
        self.__resize()
    
    def set_now_thinking(self, flag):
        
        PaintChatNode.set_now_thinking(flag)

    def clear_all(self):
        self.chat_thread.clear_all()
        self.__resize()

