import os
from PySide6.QtWidgets import QHBoxLayout,QWidget, QLabel
from PySide6.QtWidgets import QPushButton

g_mime_map = {
    ".png": "image/png",
    ".jpg": "image/jpeg",
    ".jpeg": "image/jpeg",
    ".gif": "image/gif",
    ".bmp": "image/bmp",
    ".tif": "image/tiff",
    ".tiff": "image/tiff",
    ".svg": "image/svg+xml",
    ".webp": "image/webp",
    ".emf": "image/x-emf",
    ".wmf": "application/x-msmetafile",
}


class DropedFileWidget(QWidget):
    def __init__(self):
        super().__init__()
        self.file_paths=[]

        self.file_path_label = QLabel("Please drag and drop the file into this window.")
        
        self.clear_button = QPushButton("Clear files.")
        self.clear_button.clicked.connect(self.clear_file)
        self.clear_button_function = None

        self.image_input_layout = QHBoxLayout()
        self.image_input_layout.addWidget(self.file_path_label, stretch=1)
        self.image_input_layout.addWidget(self.clear_button)
        self.setLayout(self.image_input_layout)

    def add_files(self, file_paths: list):
        """画像パスのリストを受け取り、UIを更新するヘルパーメソッド"""
        self.file_paths.extend(file_paths)
        # 重複を排除し、ソートして一貫性を保つ
        self.file_paths = sorted(list(set(self.file_paths)))
        print("self.file_paths",self.file_paths)

        if len(self.file_paths) < 2:
            self.file_path_label.setText(f"file: {os.path.basename(','.join(self.file_paths))}")
            
        elif 2 <= len(self.file_paths):
            self.file_path_label.setText(f"files: {len(self.file_paths)} files selected")
        else: # 0件の場合
            self.file_path_label.setText("Please drag and drop the file into this window.")
    def clear_file(self):
        self.file_paths = []
        self.file_path_label.setText("Please drag and drop the file into this window.")
        if self.clear_button_function:
            self.clear_button_function()

    def set_clear_button_function(self, func):
        self.clear_button_function = func


    def set_font(self, font):
        self.file_path_label.setFont(font)
        self.clear_button.setFont(font)