from PySide6.QtWidgets import QHBoxLayout,QVBoxLayout,QWidget, QListWidget,QPushButton, QMessageBox,QListWidgetItem
from PySide6.QtCore import Qt

from PySide6.QtWidgets import QApplication
from ..ChatDataBase.ChatDataBase import ChatDataBase
class ChatListWidget(QWidget):
    def __init__(self, **kwargs):
        super().__init__()
        self.layout = QVBoxLayout()


        self.open_close_button = QPushButton("<")
        self.open_close_button.clicked.connect(self.open_close)

        self.button_layout = QHBoxLayout()        
        self.delete_thread_button=QPushButton("del")
        self.create_thread_button=QPushButton("new")
        self.delete_thread_button.clicked.connect(self.delete_thread)
        self.create_thread_button.clicked.connect(self.create_thread)
        #self.layout.addWidget(self.open_close)
        self.button_layout.addStretch(1)
        self.button_layout.addWidget(self.delete_thread_button)
        self.button_layout.addWidget(self.create_thread_button)
        
        self.list_widget = QListWidget()
        self.list_widget.itemSelectionChanged.connect(self.change_selected_item)
        self.list_widget.itemChanged.connect(self.on_commit_data)

        self.layout.addLayout(self.button_layout)
        self.layout.addWidget(self.list_widget)
        self.setLayout(self.layout)

        #################################
        self.chat_data_base = ChatDataBase()


        self.create_function = None
        self.delete_function = None
        self.change_function = None
        self.open_close_function = None
        self.commit_item_data = None
        self.init_load_thread_list()

    def get_kwargs_data(self, kwargs, key, default_value):
        if key in kwargs:
            return kwargs[key]
        return default_value
    ####################################################
    def get_thread_ids_list(self):
        return self.chat_data_base.get_thread_ids_list(self)

    def set_thread_title(self, thread_id, title):
        self.chat_data_base.set_thread_title(thread_id, title)

    def update_thread_timestamp(self, thread_id):
        self.chat_data_base.update_thread_timestamp(thread_id)


    def get_all_threads_meta_sorted(self):
        return self.chat_data_base.get_all_threads_meta_sorted()
    
    def create_thread_id(self):
        return self.chat_data_base.create_thread_id()
    
    def delete_thread(self, thread_id):
        self.chat_data_base.delete_thread(thread_id)
    def set_thread_title(self, thread_id, title):
        self.chat_data_base.set_thread_title(thread_id, title)

    def close(self):
        self.chat_data_base.close()
        super().close()
    def __del__(self):
        pass
        #super().__del__()
    #####################################
    def set_create_function(self, func):
        self.create_function=func
    def set_delete_function(self, func):
        self.delete_function=func
    def set_change_function(self, func):
        self.change_function=func
    def set_open_close_function(self, func):
        self.open_close_function=func

    def set_commit_item_data(self, func):
        self.commit_item_data=func
    #####################################
    def create_thread(self):
        thread_id = self.create_thread_id()
        
        print("create_thread thread_id", thread_id)
        self.set_thread_title(thread_id, "無題")
        item = QListWidgetItem("無題")
        item.setFlags(item.flags() | Qt.ItemIsEditable)

        item.setData(Qt.UserRole, thread_id)
        self.list_widget.insertItem(0, item)

        self.update_thread_timestamp(thread_id)
        if None is not self.create_function:
            
            self.create_function(thread_id)
        self.select_item(0)

    def delete_thread(self):
        if None is self.delete_function:
            return
        # どこかの関数内で
        msg = QMessageBox()
        msg.setWindowTitle("削除確認")
        msg.setText("本当に削除しますか？")
        msg.setStandardButtons(QMessageBox.Yes | QMessageBox.No)
        msg.setDefaultButton(QMessageBox.No)

        ret = msg.exec()

        if ret == QMessageBox.Yes:

            for item in self.list_widget.selectedItems():

                thread_id = item.data(Qt.UserRole)

                if None is not self.delete_function:
                    self.delete_function(thread_id)
                row = self.list_widget.row(item)
                self.list_widget.takeItem(row)

        else:
            pass
    
    def open_close(self):
        if self.list_widget.isHidden():
            self.list_widget.show()
            self.delete_thread_button.show()
            self.create_thread_button.show()
            #self.layout.addLayout(self.button_layout)
            #self.layout.addWidget(self.list_widget)

            self.open_close_button.setText("<")
        else:
            self.list_widget.hide()
            self.delete_thread_button.hide()
            self.create_thread_button.hide()
            #self.layout.removeWidget(self.button_layout)
            #self.layout.removeWidget(self.list_widget)

            self.open_close_button.setText(">")
        self.adjustSize()
        if None is not self.open_close_function:
            self.open_close_function()
        
        
    def change_selected_item(self):
        QApplication.setOverrideCursor(Qt.WaitCursor)
        if self.change_function is not None:
            for item in self.list_widget.selectedItems():
                thread_id = item.data(Qt.UserRole)
                print("item",item.text())
                self.change_function(thread_id)
                break            
        QApplication.restoreOverrideCursor()   
    
    #######################################
    def get_open_close_button(self):
        return self.open_close_button

    ###############################################
    def init_load_thread_list(self):
        self.list_widget.clear()
        threads_meta = self.get_all_threads_meta_sorted()
        #print("threads_meta len", len(threads_meta))
        for thread_meta in threads_meta:
            thread_id = thread_meta["thread_id"]
            title = thread_meta["title"]
            created_at = thread_meta["created_at"]
            updated_at = thread_meta["updated_at"]
            #print("thread_id", thread_id)
            #print("title", title)
            #print("created_at", created_at)
            #print("updated_at", updated_at)

            item = QListWidgetItem(title)
            item.setFlags(item.flags() | Qt.ItemIsEditable)

            item.setData(Qt.UserRole, thread_id)
            self.list_widget.addItem(item)
            
    def set_title_of_selected_thread(self, title):
        for item in self.list_widget.selectedItems():
            thread_id = item.data(Qt.UserRole)
            self.set_thread_title(thread_id, title)
            self.update_thread_timestamp(thread_id)
            item.setText(title)
            break
    def get_selected_text(self):
        for item in self.list_widget.selectedItems():
            return item.text()
        return ""
    def get_now_selected_thread_id(self):
        for item in self.list_widget.selectedItems():
            return item.data(Qt.UserRole)
        
    def get_selected_thread_id(self):
        for item in self.list_widget.selectedItems():
            return item.data(Qt.UserRole)
        
              
    def select_item(self, index):
        self.list_widget.setCurrentRow(index)
    
    def set_font_size(self, size):
        self.list_widget.setFontPointSize(size)
        self.open_close_button.setFontPointSize(size)
        self.delete_thread_button.setFontPointSize(size)
        self.create_thread_button.setFontPointSize(size)
    def on_commit_data(self, editor):
        text = editor.text()
        self.commit_item_data(text)
        self.move_selected_thread_to_top()
        #print("commitData:", text)
        # DB 保存処理
    def move_selected_thread_to_top(self):
        self.move_thread_to_top(self.get_selected_thread_id())
    def move_thread_to_top(self, target_thread_id):
        # リスト内を走査して該当 item を探す
        for i in range(self.list_widget.count()):
            item = self.list_widget.item(i)
            if item.data(Qt.UserRole) == target_thread_id:
                self.list_widget.blockSignals(True)

                # アイテムを取り出す
                take_item = self.list_widget.takeItem(i)
                # 先頭に挿入
                print("take_item.text: ",take_item.text())
                self.list_widget.insertItem(0, take_item)


                self.list_widget.setCurrentItem(take_item)
                self.list_widget.blockSignals(False)
                break
