from .FlowSequentialBase import FlowSequentialBase
from .FlowCriterionAndBranching  import FlowCriterionAndBranching


class FlowWhile(FlowSequentialBase):
    def __init__(self, criterion):
        super().__init__()
        self.set_category("flow")
        self.set_type("while")
        self.criterion = criterion
        self.criterion_and_branching = FlowCriterionAndBranching()  # 条件による判別のみを担当
        self.criterion_and_branching.set_criterion(criterion)
        self.criterion_and_branching.set_branching(["True", "False"])
        print("FlowWhile.__init__", criterion)

    def set_conditions(self, criterion):
        self.criterion = criterion

    def run(self, command="", pre_respons=None, flow_data=None):
        result = ""
        while "True" == self.criterion_and_branching.check():
            result, pre_respons = super().run(command, pre_respons, flow_data)
            if "break" == result:
                return "", pre_respons
            if "continue" == result:
                result = ""
                continue
            if "return" == result:
                return "return", pre_respons

        return "", pre_respons
