from .FlowBase import FlowBase


class FlowSequentialBase(FlowBase):
    def __init__(self):
        super().__init__()
        self.set_category("flow")
        self.set_type("processbase")
        self.process_list = []

    # branching_dummy は　if などの分岐と引数の数を合わせるのに必要
    def append_process(self, process, branching_dummy=None):
        self.process_list.append(process)
        return process

    def run(self, command=None, pre_respons=None, flow_data=None):
        result = ""
        for process in self.process_list:
            #print("sq.run.type", type(process))
            result, pre_respons = process.run(command, pre_respons, flow_data)
            if "break" == result:
                self.is_break = False
                return "break", pre_respons
            if "continue" == result:
                self.is_continue = False
                return "continue", pre_respons
            if "return" == result:
                return "return", pre_respons
        return "", pre_respons
