from .FlowSequentialBase import FlowSequentialBase


class FlowFor(FlowSequentialBase):
    def __init__(self, end):
        super().__init__()
        self.set_category("flow")
        self.set_type("For")
        self.start = 0
        self.step = 1
        self.end = end

    def set(self, start, end, step):
        self.start = start
        self.step = step
        self.end = end

    def run(self, command=None, pre_respons=None, flow_data=None):
        result = ""

        for i in range(self.start, self.end, self.step):
            self.append_for_index(i)
            result, pre_respons = super().run(command, pre_respons, i)
            if "break" == result:
                self.pop_for_index()
                return "", pre_respons
            if "continue" == result:
                result = ""
                continue
            if "return" == result:
                self.pop_for_index()
                return "return", pre_respons
        self.pop_for_index()
        return "", pre_respons
