"""
Docstring for CodeExtractor
'''---
'''
で囲まれた内容を抜き出します。
"""

class FllowControlleData():
    def __init__(self):
        self.code_error = False
        self.code = ""
        self.ext_list = []  # 拡張子


g_fcd = FllowControlleData()
# ファイルの実行とputhonエラーの報告


def get_file_list(folder_path):
    """指定されたフォルダ内のファイルリストを取得する関数。

    Args:
       folder_path: ファイルリストを取得したいフォルダのパス。

    Returns:
       フォルダ内のファイルリスト。
    """
    file_list = []
    folder_path = os.path.normpath(folder_path)  # パスを正規化
    for root, _, files in os.walk(folder_path):
        for file in files:
            file_list.append(os.path.join(root, file))
    return file_list

def get_list_from_symbol_code(r_str, symbol):
    code_dict = get_program_code_from_response(r_str)
    if symbol in code_dict.keys():
        list = code_dict[symbol].split("\n")
        result = []
        for data in list:
            result.append(data.strip())
        return result
    else:
        return None

def get_program_code_from_response(r_str):
    # プログラムコードw抜き出す

    lines = r_str.split("\n")
    now_code = False
    code_dict = {}
    ctype = ""
    for line in lines:
        l_line = line.rstrip()
        l_line = l_line.lower()
        if l_line.startswith("```"):
            if False is now_code:
                now_code = True
                ctype = l_line[3:]
                if ctype not in code_dict:
                    code_dict[ctype] = ""
                print("ctype", ctype)
                continue
        if "```" == l_line:
            if now_code:
                now_code = False
                continue
        if now_code:
            code_dict[ctype] += line + "\n"
    return code_dict

def get_program_code_list_from_response(r_str):
    # プログラムコードw抜き出す

    lines = r_str.split("\n")
    now_code = False
    code_dict = {}
    code = ""
    ctype = ""
    for line in lines:
        l_line = line.rstrip()
        l_line = l_line.lower()
        if l_line.startswith("```"):
            if False is now_code:
                now_code = True
                code = ""
                ctype = l_line[3:]
                if ctype not in code_dict:
                    code_dict[ctype] = []
                print("ctype", ctype)
                continue
        if "```" == l_line:
            if now_code:
                code_dict[ctype].append(code)
                now_code = False
                continue
        if now_code:
            code += line + "\n"
    return code_dict

def save_program_code_to_temp(code_dict):

    for key, value in code_dict.items():
        if "" != key:
            if "python" == key:
                ext = ".py"
            elif "javascript" == key:
                ext = ".js"
            elif "c++" == key:
                ext = ".cpp"
            elif "c++" == key:
                ext = ".cpp"
            elif "ruby" == key:
                ext = ".rb"
            elif "perl" == key:
                ext = ".pl"
            elif "r" == key:
                ext = ".rd"
            else:
                ext = "." + key
            # コードの種類を設置
            g_fcd.ext_list.append(ext)
            print("key", key)
            tools.program_called_command_list.save_program_file(
                "temp"+ext, value)