# demo_ollama.py
from requests.sessions import session
from mini_llm import Ollama, ChatSession, LMStudio
import json

# Ollama のエンドポイント
client = LMStudio("http://localhost:1234")

#session = ChatSession(client, model="qwen3-vl:8b")
session = ChatSession(client, model="openai/gpt-oss-20b")

q = session.chat("次の問題を解く過程をすべて表示して。1+1は？", stream=True, think="high")

while True:
    item = q.get()
    #print("item:", item)
    if item is None:
        break

    channel, text = item

    if channel == "thinking":
        print("\033[90m[thinking]\033[0m", text)  # グレー表示
    elif channel == "assistant":
        print("\033[92m[assistant]\033[0m", text)
    else:
        pass
        #print("[raw]", text)
        json_str = text.split("data: ", 1)[1]
        try:
            data = json.loads(json_str)

            reasoning = data["choices"][0]["delta"].get("reasoning")
            if reasoning:
                print("reasoning",reasoning)
            content = data["choices"][0]["delta"].get("content")
            if content:
                print("content",content)
        except:
            pass
