from abc import  abstractmethod
from typing import Any, List, Optional, Dict
from langchain_core.language_models.chat_models import BaseChatModel
from langchain_core.messages import HumanMessage, AIMessage, BaseMessage, SystemMessage, AIMessageChunk
from langchain.agents import create_agent
from langchain_core.callbacks import BaseCallbackHandler
from langchain_core.tools import tool


from ...shared.exception import InterruptedException
from ...AICharacter.llms.LlmInterface import LLMInterface # Import the interface
from langgraph.graph import StateGraph
from langgraph.checkpoint.memory import MemorySaver
from langgraph.checkpoint.sqlite import SqliteSaver
import sqlite3

try:
    # ollamaライブラリがインストールされている場合、専用のエラーをインポート
    from ollama import ResponseError
except ImportError:
    ResponseError = None # インストールされていない場合はNoneにしておく

from typing import Optional, List

from typing import Annotated, TypedDict
from langgraph.graph import StateGraph, END
from langgraph.graph.message import add_messages
from langchain_core.messages import ToolMessage  # ツール結果用

from ...Word2Contents.Word2Contents import Word2Contents
import time
import os
import requests
from pathlib import Path
from ...shared import define
import base64
from ...ChatDataBase.ChatDataBase import ChatDataBase
import operator
#import GUI.PaintGUI as gui

g_mime_map = {
    ".png": "image/png",
    ".jpg": "image/jpeg",
    ".jpeg": "image/jpeg",
    ".gif": "image/gif",
    ".bmp": "image/bmp",
    ".tif": "image/tiff",
    ".tiff": "image/tiff",
    ".svg": "image/svg+xml",
    ".webp": "image/webp",
    ".emf": "image/x-emf",
    ".wmf": "application/x-msmetafile",
}


class State(TypedDict):
    messages: Annotated[list[BaseMessage], add_messages]  # メッセージ履歴
    thinking: Annotated[list[str], add_messages]  # ← これを追加
    
    # ツール結果を追加する場合（オプション）
    tool_results: list[str]  # 例: ツールの出力リスト
    #tool_results: Annotated[list[str], operator.add] 





def extract_user_input(messages):
    # HumanMessage の最後のものを探す
    for msg in reversed(messages):
        if isinstance(msg, HumanMessage):
            return msg.content
   
    raise ValueError("HumanMessage が見つかりません")

def extract_memory(messages):
    # HumanMessage と AIMessage のペアを履歴として抽出
    history = []
    for msg in messages:
        if isinstance(msg, (HumanMessage, AIMessage)):
            history.append(msg)
    
    return history

def extract_scratchpad(messages):
    # ToolMessage や FunctionCallMessage などを scratchpad として抽出
    scratchpad = []
    for msg in messages:
        if isinstance(msg, ToolMessage):
            scratchpad.append(msg)
    
    return scratchpad

class LlmBase(LLMInterface): # LlmBase implements LLMInterface
    model_name: str
    temperature: float
    llm_kwargs: Dict[str, Any]
    _supports_vision: bool
    
    llm: BaseChatModel # The actual Langchain LLM instance
    memory: SqliteSaver 
    
    #chat_history : SqliteSaver
    def __init__(self, model_identifier: str, temperature: float = 0, **kwargs):
        self.model_name = model_identifier
        self.temperature = temperature
        self.llm_kwargs = kwargs
        self.tools: List[Any] = []
        self.system_prompt: str = ""
        self._supports_vision = False # Default, to be overridden by subclasses
        self._supports_thinking = False
        self._supports_tools = False
        self.thinking_level = "medium"  # Default thinking level
        self._initialize_model_state()
        self.llm = self._initialize_llm() # Initialize the specific LLM in the constructor

        self.w2c=Word2Contents()
        self.private_memory = False
        self.name=""

        self.data_base = ChatDataBase()
        LlmBase.memory = self.data_base.get_memory()
        data = self.data_base.get_all_threads_meta_sorted()
        if None is not data and 0 < len(data):
            self.data_base.set_thread_id(self.data_base.get_thread_id())
        else:
            self.data_base.set_thread_id(self.data_base.get_thread_id())

        self.run_config = {}
        self._callback_manager = None
        ##　threddata 関連　ここまで
        # -------------------------------------------------
        # ② 既存の `self.memory_key` はそのまま使用
        # -------------------------------------------------
        #   ここは「スレッド ID」なので、ユーザーごとに変えることができます
        # -------------------------------------------------

        #self._thinking_level = "low","medium","high"

        # ツールマップ作成（名前で自動振り分け用）
        self.user_input={}
        self.tool_map = None
        
        self.app = self.create_character()
        
        self.data_base.set_update_function(self.app.update_state)

    def get_kwargs_data(self, kwargs, key, default_value):
        if key in kwargs:
            return kwargs[key]
        return default_value
 
    ######################################
    @abstractmethod
    def _initialize_llm(self) -> BaseChatModel:
        """Abstract method to initialize the specific Langchain LLM instance."""
        pass
    @abstractmethod
    def _initialize_model_state(self):
        pass
    def get_langchain_llm_instance(self) -> Optional[BaseChatModel]:
        return self.llm

#######################
    def create_character(self):

        return self.create_agent_executer()
    



    def create_agent_executer(self):
        #各種設定が行われたときに作り直す。get_responseでは作らない。連続してメッセージをやり取りするときの負荷低減        
        #self.agent = create_tool_calling_agent(self.llm, self.tools, self.prompt)
        
        self.agent = create_agent(
            model=self.llm,
            tools=self.tools,
            #prompt=self.prompt
        )

        return self.build()
        
    def build(self):
        workflow = StateGraph(state_schema=State)
        workflow.add_node("agent", self.agent_node)  # ← self.agent_node を渡す
        if 0 < len(self.tools):
            workflow.add_node("tools", self.tool_node)  # ← self.agent_node を渡す

            workflow.set_entry_point("agent")
            workflow.add_conditional_edges("agent", self.should_continue)
            workflow.add_edge("tools", "agent")
        else:
            workflow.set_entry_point("agent")

        return workflow.compile(checkpointer=self.data_base.get_memory())
    
    def get_memory(self):
        return self.data_base.get_memory()
    def get_chat_data_base(self) -> ChatDataBase:
        return self.data_base

    def set_private_memory(self, is_private: bool):
        self.data_base.set_private_memory(is_private)
    #####################################################################
    def append_tools(self, tools_list: list, new_tools: list) -> list:
        """ツールリストに新しいツール（関数 or Toolインスタンス）を追加。
        @tool付き関数は自動でToolに変換済みなので、そのまま追加。
        """
        for new_tool in new_tools:
            if callable(new_tool) and not hasattr(new_tool, 'invoke'):  # 生関数なら@toolでラップ
                new_tool = tool(new_tool)  # 自動デコレータ適用（ただし事前定義推奨）
            elif isinstance(new_tool, list):  # ネストリスト対応
                tools_list.extend(new_tool)
                continue
            tools_list.append(new_tool)
        self.tool_map = {tool.name: tool for tool in tools_list}

    def remove_empty_system_messages(self, messages):
        cleaned = []
        for m in messages:
            if isinstance(m, SystemMessage):
                if m.content is None:
                    continue
                if isinstance(m.content, str) and m.content.strip() == "":
                    continue
            cleaned.append(m)
        return cleaned

    def normalize_messages(self, messages):
        normalized = []
        for m in messages:
            content = m.content

            # ★ list → str に変換
            if isinstance(content, list):
                # ChatML 形式を単純テキストに変換
                texts = []
                for block in content:
                    if isinstance(block, dict) and block.get("type") == "text":
                        texts.append(block.get("text", ""))
                content = "\n".join(texts)

            # None や空文字はスペースに
            if content is None or content == "":
                content = " "

            data = dict(m.__dict__)
            data["content"] = content
            normalized.append(type(m)(**data))

        return normalized



    def agent_node(self, state: State) -> State:
        
        # ツールが指定されている場合のみAgentExecutorを使用
        return self.agent.invoke(state)   # state そのまま渡すだけでOK！

    # tool_node: リスト登録ツールを自動実行（分岐なし！）
    def tool_node(self, state: State) -> State:
        outputs = []
        last_message = state["messages"][-1]

        for tool_call in last_message.tool_calls:  # 複数ツール呼び出し対応
            tool_name = tool_call["name"]
            tool_args = tool_call["args"]

            # 自動振り分け: tool_map.get()で名前からツール取得
            selected_tool = self.tool_map.get(tool_name)
            if selected_tool:
                tool_result = selected_tool.invoke(tool_args)  # 動的実行
                outputs.append(tool_result)
            else:
                outputs.append(f"不明なツール: {tool_name}")

        # 結果をToolMessageとして状態に追加（LLMが読めるよう）
        return {
            "messages": [ToolMessage(
                content=str(outputs),
                tool_call_id=last_message.tool_calls[0].get("id") if last_message.tool_calls else None
            )]
        }
    
    def should_continue(self, state: State):
        last_message = state["messages"][-1]
        return "tools" if last_message.tool_calls else END
 ###########################################################


    def clear_memory(self):
        self.data_base.clear_thread()
        
        self.set_system_prompt(self.system_prompt)
        
              
    def set_thread_id(self, thread_id):
        self.data_base.set_thread_id(thread_id)


    
    def set_system_prompt(self, system_prompt: str):
        self.system_prompt = system_prompt
        self.data_base.set_system_prompt(system_prompt)
        #print("set_system_prompt:", state)
        #LlmBase.memory.put(config=config,checkpoint=history, metadata={}, new_versions=new_versions)
        return True



    def set_private_memory(self, is_private):
        self.data_base.set_private_memory(is_private)

    def set_name(self, name):
        self.name = name

        

    def update_input(
        self,
        imput_prompt_text: str,
        image_data_urls: Optional[List[str]] = None,
        target_index: int = None):
        """
        会話履歴内のユーザー入力（HumanMessage）を更新します。
        - target_index が指定されればその位置の HumanMessage を更新
        - 指定がなければ最後の HumanMessage を更新

        Args:
            imput_prompt_text (str): 更新するユーザー入力の文字列
            image_data_urls (Optional[List[str]]): 画像URLリスト
            target_index (Optional[int]): 更新対象のインデックス（Noneなら末尾）
        """
        pass
    def update_input_text(
        self,
        imput_prompt_text: str,
        target_index: int = None):
        """
        会話履歴内のユーザー入力（HumanMessage）を更新します。
        - target_index が指定されればその位置の HumanMessage を更新
        - 指定がなければ最後の HumanMessage を更新

        Args:
            imput_prompt_text (str): 更新するユーザー入力の文字列
            image_data_urls (Optional[List[str]]): 画像URLリスト
            target_index (Optional[int]): 更新対象のインデックス（Noneなら末尾）
        """
        self.data_base.update_input_text(imput_prompt_text, target_index)


###################

    def update_tools(self, tools: List[Any]):
        """Updates the list of tools available to the LLM provider."""
        self.tools = tools

    def update_system_prompt(self, system_prompt: str):
        """Updates the system prompt for the LLM provider."""
        self.system_prompt_str = system_prompt
        self.set_system_prompt(system_prompt)

#########################
    def _encode_image_to_data_url(self, image_path_or_url: str) -> str:
        """画像パスまたはURLからBase64エンコードされたデータURL文字列を生成する"""
        if image_path_or_url.startswith("http://") or image_path_or_url.startswith("https://"):
            # import requests # AIAgent.py の冒頭で import 済みのはず
            response = requests.get(image_path_or_url, timeout=10)
            response.raise_for_status()
            image_data = response.content
            mime_type = response.headers.get('Content-Type', 'image/jpeg')
        elif Path(image_path_or_url).exists():
            import os # ローカルインポートで良いか、クラス冒頭でimportするか検討
            with open(image_path_or_url, "rb") as image_file:
                image_data = image_file.read()
            _, ext = os.path.splitext(image_path_or_url.lower())
            mime_type = g_mime_map.get(ext)
        else:
            raise FileNotFoundError(f"Image path or URL not found or not accessible: {image_path_or_url}")


        base64_encoded_data = base64.b64encode(image_data).decode('utf-8')
        return {"type": "image", "base64": base64_encoded_data, "mime_type":mime_type}
        #return {"type": "image_url", "image_url": image_path_or_url}

        #return {"type": "image",
        #        "contents":{ "base64": base64_encoded_data, "mime_type":mime_type
        #                    }
        #        }
        
    
    def __create_text_contents(self, text):
        content_parts = {"type": "text", "text": text}
        return content_parts
    def _create_image_contents(self, image_path_or_url: str):
        return self._encode_image_to_data_url()
        
    def get_current_message_content(self,prompt,file_paths):
        content_parts = []
        #print("get_current_message_content file_paths",file_paths)
        for file_path in file_paths:
            if file_path.lower().endswith(('.png', '.jpg', '.jpeg', '.bmp', '.gif')):
                if self._supports_vision:
                    content_parts.append(self._encode_image_to_data_url(file_path))
            if file_path.lower().endswith(('.pdf')):
                content_parts.append(self.open_pdf(file_path))
            if file_path.lower().endswith(('.txt', '.md', ".csv", ".json", ".log", ".xml", ".html", "htm", ".css", ".js", ".sql", ".yaml", ".yml", ".ini",
                                           ".py", ".java", ".c", ".cpp", ".h", ".cs", ".rb", ".rs", ".php", ".swift", ".kt", ".m", ".sh", ".r", ".pl", ".vb", ".ts", ".dart")):
                content_parts.append(self.open_text(file_path))
            if file_path.lower().endswith(('.docx', '.doc')):
                content_parts.extend(self.open_words(file_path))
       # Construct the HumanMessage content, handling multimodal input
        content_parts.append(self.__create_text_contents(prompt))
        #print("content_parts",content_parts)
        return content_parts


    def open_pdf(self, pdf_path):
        from pdfminer.high_level import extract_text
        results = ""
        
        text = extract_text(pdf_path)
        results += f"\n\n--- Content from {os.path.basename(pdf_path)} ---\n\n"
        results += text.encode("utf-8", errors="replace").decode("utf-8") + "\n"
        results += "--- End of Content ---\n\n"

        return self.__create_text_contents(results)
    
    def open_text(self, text_path):
        results = ""
       
        
        with open(text_path, 'r', encoding='utf-8', errors='ignore') as file:
            text = file.read()
        results += f"\n\n--- Content from {os.path.basename(text_path)} ---\n\n"
        results += text.encode("utf-8", errors="replace").decode("utf-8") + "\n"
        results += "\n--- End of Content ---\n\n"

        return self.__create_text_contents(results)
    
    def open_words(self, word_paths):
        w2c=Word2Contents()
        result = w2c.open(word_paths)
        return result

################################################################
    def get_response(self,
                     prompt: str,
                     #chat_history: Optional[MemorySaver] = None,
                     file_paths: Optional[List[str]] = None,
                     system_prompt: Optional[str] = None,
                     tools: Optional[List[Any]] = None,
                     callbacks: Optional[BaseCallbackHandler] = None,
                     **kwargs) -> str:


        # Construct the HumanMessage content, handling multimodal input

                        
        if file_paths is None:
            file_paths = []
        if system_prompt is not None:
            self.set_system_prompt(system_prompt)
        #print("file_path ", file_paths)
        current_message_content = self.get_current_message_content(prompt, file_paths)
        #history = chat_history if chat_history else []
        if self.data_base.is_thread_Nodata():
            agent_input = {
                "messages": [SystemMessage(content=self.system_prompt), HumanMessage(content=current_message_content)],
            }
        else:
            agent_input = {
                "messages": [
                    HumanMessage(content=current_message_content)
                ],
            }

        run_config = {
            "configurable": {"thread_id": self.data_base.get_thread_id()},
            "callbacks": callbacks
        }
        #print("run_config",run_config)
        self.run_config = run_config
        self._callback_manager = callbacks
        #print("pre  get_response agent_input:", agent_input)
        agent_input["messages"] = self.remove_empty_system_messages(agent_input["messages"])
        self.user_input = agent_input
        print("pre  get_response agent_input:", agent_input)
        try:

            for output in self.app.stream(agent_input, config=run_config,**kwargs):
                # print("output in get_response:", output)
                for key, value in output.items():
                    # print("output key:", key)
                    # print("message chunk:", value)
                    if "messages" in value:

                        for msg in value["messages"]:
                            if hasattr(msg, 'content') and msg.content:
                                response = msg.content
                                # callbackがトークンを逐次print（上記のon_llm_new_tokenで処理）
                                pass  # ここはループでチャンクを扱うが、callbackがメイン表示

                    if  "thinking" in value:
                         print("thinking chunk:", value)
                         # ここで「思考中」文字列を UI に渡す
                         # 例: self._last_thinking = value   # 1 行だけでも保存すれば OK
                         pass

            # ★★★【重要】成功した場合の戻り値を返す処理を追加 ★★★
            if isinstance(response, dict):
                return response.get("output", f"AgentExecutor returned a dict without 'output' key: {response}")
            #print("response",response)
            return str(response)
        except InterruptedException:
            print(f"{type(self).__name__} ({self.model_name}): AgentExecutor execution interrupted.")
            raise # AIAgent側で処理するために再スロー
        except NotImplementedError as e_not_implemented:
            # bind_tools が実装されていないモデルでツールを使おうとした場合のエラー
            import traceback
            error_msg = f"{type(self).__name__} ({self.model_name}) error: The selected model or its LangChain wrapper does not support the required tool-calling feature (bind_tools). Please use a tool-compatible model (like `devstral` with the latest `langchain-ollama` package) or disable tools. Original error: {e_not_implemented}"
            print(error_msg)
            traceback.print_exc()
            return error_msg
        except ResponseError as e:
            error_msg = f"Ollama server returned an error: {e}"
            print(error_msg)
            # このエラーもGUIに返す
            return f"{type(self).__name__} AgentExecutor error: {error_msg}"
        except Exception as e_agent:
            import traceback
            print(f"{type(self).__name__}: Error during AgentExecutor execution: {e_agent}")
            traceback.print_exc() # デバッグ用に詳細なエラー情報を出力
            return f"{type(self).__name__} AgentExecutor error: {e_agent}"
        except BaseException as e_agent:
            import traceback
            print(f"{type(self).__name__}: Error during AgentExecutor execution: {e_agent}")
            traceback.print_exc() # デバッグ用に詳細なエラー情報を出力
            return f"{type(self).__name__} AgentExecutor error: {e_agent}"



    @property
    @abstractmethod # This must be abstract in LlmBase as it's specific to each LLM
    def supports_vision(self) -> bool:
        pass

    def get_user_input(self):
        return self.user_input

        