from ...AICharacter.llms.LlmBase import LlmBase # Import the new base class
# LangChainDeprecationWarning に従い、新しいパッケージからインポートする
# 古いインポート: from langchain_community.chat_models import ChatOllama
# これにより、bind_tools をサポートする最新の ChatOllama が使用される
from langchain_openai import ChatOpenAI
from langchain_core.language_models.chat_models import BaseChatModel


from ...shared.exception import InterruptedException as InterruptedException # または共通の例外モジュールから



import lmstudio as lms


class LMStudioLLM(LlmBase): # Inherit from LlmBase
    def __init__(self, model_identifier: str = "llama2", temperature: float = 0, **kwargs):
        super().__init__(model_identifier, temperature, **kwargs) # Call base class constructor
        
        # Specific OllamaLLM initialization
        # self.llm is already initialized in LlmBase.__init__ via _initialize_llm()
        

    def _initialize_model_state(self):
        model = self.get_lmstudio_model_states(self.model_name)
        # Easy image support detection (more accurate detection needed)
        self._supports_vision = getattr(model, "vision",False)
        self._supports_tools = getattr(model, "trainedForToolUse",False)
        self._supports_thinking = getattr(model, "thinking",False)
        self._supports_thinking = True
        print("model:", model)
        #self._supports_tools = True
        
        #self.llm_kwargs["streaming"]= True

    def _initialize_llm(self) -> BaseChatModel:
        try:
            rs=None
            rs_e=None
            if self._supports_thinking:
                if "gpt-oss" in self.model_name.lower():
                    #self.llm_kwargs["reasoning_effort"] =  self.thinking_level
                    #self.llm_kwargs["reasoning"] = True
                    rs = True
                    rs_e =  self.thinking_level
                else:
                    #self.llm_kwargs["reasoning"] = True
                    #self.llm_kwargs["thinking"] = True
                    rs = True
            print("rs,rs_e:",rs,rs_e)
            self.llm = ChatOpenAI(
#                base_url="http://localhost:1234/v1",
                base_url="http://localhost:1234/v1",
                #base_url="http://localhost:1234/v1/chat/completions",
                api_key="not-needed",  # ローカルLLMではAPIキーは不要
                model=self.model_name,
                temperature=self.temperature,
                streaming=True,
                #reasoning=rs,
                #thinking=rs,
                reasoning_effort=rs_e,                
                #validate_model_on_init=True,
                #reasoning=rs,
                #thinking=rs,
                **self.llm_kwargs # kwargsではなくself.llm_kwargsを使用
            )
            return self.llm
        except Exception as e:
            print(f"LMstudio初期化エラー: {e}. モデル名: {self.model_name}, kwargs: {self.llm_kwargs}")
            raise
        
    @property
    def supports_vision(self) -> bool:
        return self._supports_vision
    @property
    def supports_tools(self) -> bool:
        return self._supports_tools
    @property
    def supports_thinking(self) -> bool:
        return self._supports_thinking



        
    def get_lmstudio_model_states(self, model_name: str):
        """
        lmstudioのモデルのステータスを返す
        
        """
        
        for model in lms.list_downloaded_models():
            if model.model_key == model_name:
                return model.__dict__["_data"]
    def set_thinking_level(self, level: str):
        """
        thinkingレベルを設定する。
        level: "low", "medium", "high"
        """
        self.thinking_level = level