
from .LlmBase import LlmBase # Import the new base class
from langchain_google_genai import ChatGoogleGenerativeAI
from langchain_google_genai.chat_models import ChatGoogleGenerativeAIError
from langchain_core.language_models.chat_models import BaseChatModel # SystemMessage を追加
from langchain_core.messages import HumanMessage, AIMessage, BaseMessage, SystemMessage, AIMessageChunk
from typing import List, Optional, Any # Any を追加
from ...shared.exception import InterruptedException as InterruptedException

class GeminiLLM(LlmBase): # Inherit from LlmBase
    def __init__(self, model_identifier: str = "gemini-2.5-flash", temperature: float = 0, **kwargs):

        super().__init__(model_identifier, temperature, **kwargs) # Call base class constructor
        

    def _initialize_model_state(self):
        self._supports_tolls = True
        self._supports_vision = True
        self._supports_thinking = True
        #self.llm_kwargs["streaming"]= True

    def _initialize_llm(self) -> BaseChatModel:
        try:
            if self.supports_thinking:
                self.llm_kwargs["thinking_budget"] = 1024
            self.llm = ChatGoogleGenerativeAI(
                model=self.model_name,
                temperature=self.temperature,
                streaming=True,
                **self.llm_kwargs # kwargsではなくself.llm_kwargsを使用
            )
            return self.llm
        except Exception as e:
            print(f"GeminiLLM初期化エラー: {e}. モデル名: {self.model_name}")
            # フォールバックやデフォルトモデルでの再試行などを検討
            raise


    @property
    def supports_vision(self) -> bool:
        return self._supports_vision


    @property
    def supports_tools(self) -> bool:
        return self._supports_tolls
    @property
    def supports_thinking(self) -> bool:
        return self._supports_thinking
