import inspect
import sys
import os

from PySide6.QtWidgets import QApplication, QWidget, QVBoxLayout, QHBoxLayout, QLabel, QPushButton, QSizePolicy, QFileDialog, QSpinBox,QListWidget
from PySide6.QtGui import QFont
from PySide6.QtCore import Qt, QEvent, QCoreApplication ,Signal, QThread, QObject

from typing import Any
from langchain_core.callbacks import BaseCallbackHandler
from typing import  Any

import time
import base64

import requests
from ..core.shared.exception import InterruptedException as InterruptedException
from ..core.shared.define import WORK_SPACE_DIR
from ..core.AICharacter.AICharacter import AICharacter
from ..core.GUI.PaintGUI import PaintChatNode

from ..core.GUI.PaintGUI import ChatPaintWidget
from ..core.GUI.UserInputWidget import UserInputWidget
from ..core.GUI.DropedFileWidget import DropedFileWidget
from ..core.GUI.ModelSelectWidget import ModelSelectWidget
from ..core.GUI.WebSearchWidget import WebSearchWidget
from ..core.AICharacter.AICharacter import AICharacter
from ..function_calling.web_search import get_tools_list

import inspect
class ChatWidget(QWidget):
    update_signal = Signal(str, str)  # title, text用

    def __init__(self, agent):
        super().__init__()

        self.chat_thread = ChatPaintWidget()
       
        self.setAcceptDrops(True)   # ← これが必須
        # --- Font settings ---
        self.current_default_font_size = 14
        self.current_label_font_size = 12
        self.current_button_font_size = 13
        self.current_groupbox_font_size = 14
        self.default_font_name = "Arial"    

        # title
        self.title = QLabel("PaintGUI\r\n")
        self.title.setFixedHeight(30)
        self.title.setFont(QFont("Arial", 30))
        self.title.setAlignment( Qt.AlignCenter)
        
        self.model_select_widget = ModelSelectWidget()
        self.model_select_widget.set_selected_function(self.selected_model)
        self.sep1 = QLabel("-------------------------------------------------------------------------------------------------")

        self.sep1.setFixedHeight(20)
        self.sep1.setAlignment(Qt.AlignCenter)
        font = QFont("Arial", 20)
        font.setBold(True) # 太字に設定
        self.sep1.setFont(font)

        self.sep2 = QLabel("-------------------------------------------------------------------------------------------------")
        self.sep2.setFixedHeight(20)
        self.sep2.setAlignment(Qt.AlignCenter)
        self.sep2.setFont(font)


        #image inpput

        self.file_paths=[]
        self.droped_file_widget = DropedFileWidget()

        # input 入力欄
        self.input_widget = UserInputWidget()
        self.input_widget.set_send_function(self.send_message)
        self.input_widget.set_stop_function(self.stop_message)

        # web search widget
        self.web_search_widget = WebSearchWidget()
        self.input_widget.insert_widget(self.web_search_widget, 1)
        self.web_search_widget.set_changed_function(self.change_web_search_enabled)

        # フォントサイズ変更UI
        self.font_control_layout = QHBoxLayout()
        font_size_label = QLabel("Global Font Size:")
        self.font_control_layout.addWidget(font_size_label)
        self.font_size_spinbox = QSpinBox()
        self.font_size_spinbox.setRange(8, 30) # フォントサイズの範囲
        self.font_size_spinbox.setValue(self.current_default_font_size)
        self.font_control_layout.addWidget(self.font_size_spinbox)
        apply_font_button = QPushButton("Apply Font Size")
        apply_font_button.clicked.connect(self.apply_global_font_size)
        self.font_control_layout.addWidget(apply_font_button)




        # Main layout
        main_layout = QVBoxLayout(self)
        main_layout.addWidget(self.title)
        main_layout.addWidget(self.model_select_widget)
        main_layout.addWidget(self.sep1)
        main_layout.addWidget(self.chat_thread, stretch=1)
        main_layout.addWidget(self.sep2)

        main_layout.addWidget(self.droped_file_widget)

        main_layout.addWidget(self.input_widget)   
        self.input_widget.insert_layout(self.font_control_layout, 1)     
        
        
        self.update_signal.connect(self._append_node_handler)

        self.thread = None

        self.model_name = agent.get_model_name()
        self.ai_character = agent
        # 動作確認用
        # スレッド作成


    def browse_image(self):
        # WORK_SPACE_DIR が設定されていればそこから開始、なければホームディレクトリ
        start_dir = WORK_SPACE_DIR if WORK_SPACE_DIR and os.path.isdir(WORK_SPACE_DIR) else os.path.expanduser("~")

        # 複数ファイル選択を許可
        filePaths, _ = QFileDialog.getOpenFileNames(self, "Select vision", start_dir, "vision (*.png *.jpg *.jpeg *.bmp *.gif)")
        if filePaths:
            self.add_vision(filePaths)

    def add_file(self, file_paths: list):
        self.droped_file_widget.add_files(file_paths)

    def dragEnterEvent(self, event):
        # ドラッグされたデータにURL(ファイルパス)が含まれているかチェック
        if event.mimeData().hasUrls():
            event.acceptProposedAction() # ドロップ操作を受け入れる
        else:
            event.ignore() # 受け入れない

    def dropEvent(self, event):
        # ドロップされたファイルパスを取得
        urls = event.mimeData().urls()

        self.file_paths = []
        for url in urls:
            if url.isLocalFile():
                file_path = url.toLocalFile()
                print("type file_path",type(file_path))
                print("type url",type(url))
                print("file_path",file_path)
                print("url",url)
                self.file_paths.append(file_path)

        if self.file_paths:
            self.add_file(self.file_paths)

    def clear_image(self):
        self.selected_image_path = []
        self.image_path_label.setText("Image (optional): None")

############################################################# 
    def selected_model(self,mode_name: str):
        
        if self.ai_character is None:
            self.model_name = mode_name
            self.ai_character = AICharacter(self.model_name, "", [], False,llm_model=self.model_name)
        else:
            if self.model_name != mode_name:
                self.model_name = mode_name
                tools = self.ai_character.get_tools()
                name = self.ai_character.get_name()
                self.ai_character = AICharacter(name, "", tools, False,llm_model=self.model_name)
        text=""
        if self.ai_character.get_supports_tools():
            text += "tools"
        if self.ai_character.get_supports_vision():
            if text!="":
                text += ", "
            text += "vision"
        if self.ai_character.get_supports_thinkings():
            if text!="":
                text += ", "
            text += "thinking"
        self.model_select_widget.set_tools_vision_text(text)
        # チャットスレッドにメッセージを追加         
    def send_message(self, message=None):

        if message:
            web_tool = []
            if self.web_search_widget.is_search_enabled():
                    web_tool = get_tools_list()
            if self.ai_character is None:
                
                self.model_name = self.model_select_widget.get_selected_model()
                self.ai_character = AICharacter(self.model_name, "", [] + web_tool, False,llm_model=self.model_name)
                
            else:
                if self.model_name != self.model_select_widget.get_selected_model():
                    self.model_name = self.model_select_widget.get_selected_model()
                    tools = self.ai_character.get_tools()
                    name = self.ai_character.get_name()
                    self.ai_character = AICharacter(name, "", tools + web_tool, False,llm_model=self.model_name)
            AICharacter.set_default_llm_model(self.model_name)
            # チャットスレッドにメッセージを追加
            self.chat_thread.append_node("user", message)
            self.chat_thread.append_node(self.ai_character.get_name(),"")

            
            # ワーカースレッドを作成して処理を移す
            self.thread = QThread()
            self.worker = AppendNodeWorker(self.ai_character, message,
                                           self.file_paths)
            self.worker.moveToThread(self.thread)

            # スレッドが開始したらワーカーのrunを実行
            self.thread.started.connect(self.worker.run)
            # 処理が終わったら結果を受け取る
            self.worker.finished.connect(self.on_response_received)
            # スレッド終了時にスレッドを削除
            self.worker.finished.connect(self.thread.quit)
            self.worker.finished.connect(self.worker.deleteLater)
            self.thread.finished.connect(self.thread.deleteLater)

            # 停止ボタンの有効化

            # スレッド開始
            self.thread.start()


    def stop_message(self):

            
        if self.worker:
            self.worker.cancel() # 各ワーカーにキャンセルを通知
        

        
        # 実行キューをクリアし、処理インデックスをリセット
        #self.model_task_queue.clear()
        #self.processing_model_index = -1 
        
        #QMessageBox.information(self, "Stopped", "Processing of all models has been requested to stop.")
    def change_web_search_enabled(self, state: bool):
        print(f"Web Search Enabled changed: {state}")
        if None is self.ai_character:
            return

        web_tool = []
        if state:
            web_tool = get_tools_list()
        tools = self.ai_character.get_tools()
        name = self.ai_character.get_name()

        self.ai_character = AICharacter(name, "", tools + web_tool, False,llm_model=self.model_name)        

    def on_response_received(self, response):
        # レスポンスを受け取って表示
        # AICharacter.get_respons の中で表示は更新されているはずなので、
        # ここではUIの制御（ボタンの再有効化など）を行います。
        # response引数はAppendNodeWorker.finishedから渡されますが、
        # 現在の設計では表示には使用しません。

        self.input_widget.reset_send_button()
    def append_node(self, title, text):
        #self.chat_thread.append_node(title, text)
        self.update_signal.emit(title, text)
#        QCoreApplication.postEvent(self, AppendNodeEvent(title, text))
    def _append_node_handler(self, title, text):
        # 実際の更新処理
        self.chat_thread.append_node(title, text)
        self.update()  # QWidgetのupdateメソッド
        QApplication.processEvents()  # イベント即時処理

    def update(self):
        super().update()
        QApplication.processEvents()  # イベントを即座に処理
        
    def append_text(self, text):

#        self.chat_thread.append_text(text)
#        self.update()
#        for frame in inspect.stack():
#            print(frame.filename, frame.lineno, frame.function)

        QCoreApplication.postEvent(self, AppendTextEvent(text))

    def set_last_node_text(self, text):
        # self.chat_thread.set_last_node_text(text)
        QCoreApplication.postEvent(self, SetLastNodeText(text))
        self.update()

    def new_streaming_node(self, title):
        # ChatPaintWidgetの新しいメソッドを呼び出す
        # これはUIスレッドから直接呼び出されることを想定
        self.chat_thread.new_streaming_node(title)

    def set_agent(self, agent):
        self.ai_character = agent
        # self.update()

    def customEvent(self, event):
        if event.type() == AppendNodeEvent.EventType:
            self.chat_thread.append_node(event.name, event.text)
            self.update()
        elif  event.type() == AppendTextEvent.EventType:
            
            self.chat_thread.append_text(event.text)
            self.update()
        elif   event.type() == SetLastNodeText.EventType:
            self.chat_thread.set_last_node_text(event.text)
            self.update()


    def _apply_current_font_settings(self):
        default_font = QFont(self.default_font_name, self.current_default_font_size)
        label_font = QFont(self.default_font_name, self.current_label_font_size)
        button_font = QFont(self.default_font_name, self.current_button_font_size)
        groupbox_font = QFont(self.default_font_name, self.current_groupbox_font_size, QFont.Bold)
        #self.enable_warmup = True

        self.setFont(default_font)
        if hasattr(self, 'agent_combo'): # 初期化順序によるエラー回避

            self.input_edit.setFont(default_font)
            self.droped_file_widget.setFont(default_font)
            self.input_widget.setFont(default_font)

            #self.clear_outputs_button.setFont(button_font)

        if hasattr(self, 'font_size_spinbox'): # フォント変更UIが初期化されていれば
            self.font_control_layout.itemAt(0).widget().setFont(label_font) # Global Font Size Label
            self.font_size_spinbox.setFont(default_font)
            # self.font_control_layout.itemAt(2).widget().setFont(button_font) # Apply Font Button
            # self.global_settings_layout.itemAt(0).widget().setFont(label_font)
            self.font_control_layout.itemAt(2).widget().setFont(button_font) 
        #self.update_model_views_font()
        self.chat_thread.update_font_size(self.current_default_font_size)

    def apply_global_font_size(self):
        new_base_size = self.font_size_spinbox.value()
        self.current_default_font_size = new_base_size
        # 他のフォントサイズもベースサイズに基づいて調整する（例）
        self.current_label_font_size = max(8, int(new_base_size * 0.85)) # ラベルは少し小さく
        self.current_button_font_size = max(8, int(new_base_size * 0.9))  # ボタンも調整
        self.current_groupbox_font_size = new_base_size # グループボックスは同じか少し大きく

        self._apply_current_font_settings()
        
        #self.update_model_views_font() # 各モデルビューのフォントも更新



g_mime_map = {
    ".png": "image/png",
    ".jpg": "image/jpeg",
    ".jpeg": "image/jpeg",
    ".gif": "image/gif",
    ".bmp": "image/bmp",
    ".tif": "image/tiff",
    ".tiff": "image/tiff",
    ".svg": "image/svg+xml",
    ".webp": "image/webp",
    ".emf": "image/x-emf",
    ".wmf": "application/x-msmetafile",
}




class AppendNodeWorker(QObject):
    finished = Signal(str)  # 処理が終わったときに結果を送信するシグナル
    image_count=0
    def _encode_image_to_data_url(self, image_path_or_url: str) -> str:
        """画像パスまたはURLからBase64エンコードされたデータURL文字列を生成する"""
        if image_path_or_url.startswith("http://") or image_path_or_url.startswith("https://"):
            # import requests # AICharacter.py の冒頭で import 済みのはず
            response = requests.get(image_path_or_url, timeout=10)
            response.raise_for_status()
            image_data = response.content
            mime_type = response.headers.get('Content-Type', 'image/jpeg')
        elif Path(image_path_or_url).exists():
            import os # ローカルインポートで良いか、クラス冒頭でimportするか検討
            with open(image_path_or_url, "rb") as image_file:
                image_data = image_file.read()
            _, ext = os.path.splitext(image_path_or_url.lower())
            mime_type = g_mime_map.get(ext)
        else:
            raise FileNotFoundError(f"Image path or URL not found or not accessible: {image_path_or_url}")


        base64_encoded_data = base64.b64encode(image_data).decode('utf-8')
        result={
            "type":"image",
            "mime_type":mime_type,
            "base64":base64_encoded_data
        }
        AppendNodeWorker.image_count += 1
        return result
   
    
    def __init__(self, agent, message, file_paths):
        super().__init__()
        self.ai_character = agent
        self.message = message

        self.file_paths = file_paths
    def run(self):
        # 重い処理をここで行う
        AICharacter.set_callbacks([get_stc_handler()])
        response = self.ai_character.get_response(self.message, self.file_paths )
        self.finished.emit(response)  # 結果をシグナルで送信

        pass
    def cancel(self):
        print(f"Worker {self.model_index}: Cancellation requested.")
        InterruptedException.set_cancel(True)
        pass

class AppendNodeEvent(QEvent):
    # EventType = QEvent.registerEventType()
    EventType = QEvent.Type(QEvent.registerEventType())  # Use QEvent.Type()

    def __init__(self, name, text):
        super().__init__(AppendNodeEvent.EventType)
        self.name = name
        self.text = text


class AppendTextEvent(QEvent):
    # EventType = QEvent.registerEventType()
    EventType = QEvent.Type(QEvent.registerEventType())  # Use QEvent.Type()

    def __init__(self, text):
        super().__init__(AppendTextEvent.EventType)

        self.text = text

class SetLastNodeText(QEvent):
    # EventType = QEvent.registerEventType()
    EventType = QEvent.Type(QEvent.registerEventType())  # Use QEvent.Type()

    def __init__(self, text):
        super().__init__(SetLastNodeText.EventType)

        self.text = text


class MyStreamlitCallbackHandler(BaseCallbackHandler):

    def __init__(self, container):
        self.container = container
        self.token_buffer = ""
        self.last_update_time = time.time()
        self.update_interval = 0.1 # 更新間隔を秒単位で指定 (例: 0.1秒)
        # LangChain の新仕様に対応するため追加
        self.parent_run_id = None
        self.run_id = None
        self.now_thinking = False
        # LangChain が callback handler を「コンテナ」として扱うため必要
        #self.handlers = []
        #self.inheritable_handlers = []
        #self.inheritable_tags = []
        #self.inheritable_metadata = []

    def on_llm_new_token(self, token: str, **kwargs: Any) -> None:
        #print("newtoken type", type(token))
        if isinstance(token, dict):
        #    token = "".join(token)
            print("erro newtoken is dict", token,len(token))

            
        if isinstance(token, list):

            if len(token) == 1:
                 if isinstance(token[0], dict):

                    if "text" in token[0]:
                        if False is self.now_thinking:
                            self.now_thinking = False
                            if self.token_buffer:
                                self.container.append_text(self.token_buffer)
                                self.token_buffer = ""
                            self.last_update_time = current_time
                        token=token[0]["text"]

                    elif "thinking" in token[0] or "reasoning" in token[0] or "reasoning_contents" in token[0]:
                        if False is self.now_thinking:
                            self.now_thinking = True
                            if self.token_buffer:
                                self.container.append_text(self.token_buffer)
                                self.token_buffer = ""
                            self.last_update_time = current_time                        
                        token=token[0]["thinking"]

                 else: 
                    token = "".join(token)

        InterruptedException.append_response(token)
        if InterruptedException.is_cancelled():
            InterruptedException.set_cancel(False)
            raise BaseException("test exception")

        if "" != token:
            if self.now_thinking:
                #前がthinkingの時これまでたまってたthinkingトークンを追加
                if self.token_buffer:
                    self.container.append_text(self.token_buffer)
                    self.token_buffer = ""
                
            self.now_thinking = False
            PaintChatNode.set_now_thinking(self.now_thinking)
            self.__append_streaming_token(token)
        #print("kwargs:", kwargs.keys())
        if "chunk" in kwargs:
            chunk = kwargs["chunk"]
            #print("chunk", chunk)
            if hasattr(chunk, "message"):
                #print("chunk message", chunk.message)
                if hasattr(chunk.message, "additional_kwargs"):
                    if "reasoning_content" in chunk.message.additional_kwargs:
                       #print("reasoning_content", chunk.message.additional_kwargs["reasoning_content"])
                       #前がノーマルの時これまでたまってたノーマルトークンを追加
                       if False is self.now_thinking:
                            if self.token_buffer:
                                self.container.append_text(self.token_buffer)
                                self.token_buffer = ""

                       self.now_thinking = True
                       PaintChatNode.set_now_thinking(self.now_thinking)
                       self.__append_streaming_token(chunk.message.additional_kwargs["reasoning_content"])
                if hasattr(chunk.message, "reasoning"): 
                    pass 
                    #print("reasoning", chunk.message.reasoning)
            else:
                self.now_thinking = False
                PaintChatNode.set_now_thinking(self.now_thinking)
    def __append_streaming_token(self,token):
        self.token_buffer += token 
        current_time = time.time()
        if current_time - self.last_update_time >= self.update_interval:
            if self.token_buffer:
                self.container.append_text(self.token_buffer)
                self.token_buffer = ""
            self.last_update_time = current_time        
    def on_llm_end(self, response: Any, **kwargs: Any) -> None:
        """LLMのストリーミングが終了したときに呼び出される"""
        if self.token_buffer: # バッファに残りがあれば全て送信
            self.container.append_text(self.token_buffer)
            self.token_buffer = ""

    def on_tool_start(self, serialized, input_str, *, run_id, parent_run_id = None, tags = None, metadata = None, inputs = None, **kwargs):
        tool_name = serialized.get("name")
        if tool_name:
            print(f"ツール '{tool_name}' が開始されました。")
        return super().on_tool_start(serialized, input_str, run_id=run_id, parent_run_id=parent_run_id, tags=tags, metadata=metadata, inputs=inputs, **kwargs)
#---------------
##動作確認用ワーカースレッド
#class TextWorker(QObject):
#    text_generated = Signal(str)   # メインスレッドに送るシグナル
#    running = True
#
#    def run(self):
#        count = 0
#        while self.running:
#            count += 1
#            #self.text_generated.emit(f"Line {count}")
#            append_text(f"Line {count}\n")
#            QThread.sleep(0.01)  # 1秒ごとに追加
#
    
_g_app_instance = None
_g_my_widget_instance = None

def _get_app_instance():
    global _g_app_instance
    # QApplication.instance() を使って既存のインスタンスを取得、なければ作成
    _g_app_instance = QApplication.instance()
    if _g_app_instance is None:
        _g_app_instance = QApplication(sys.argv)
    return _g_app_instance

def _get_my_widget_instance(agent=None):
    global _g_my_widget_instance

    if _g_my_widget_instance is None:
        _g_my_widget_instance = ChatWidget(agent)
        # ChatWidget のデフォルト設定 (必要に応じて)
        _g_my_widget_instance.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        _g_my_widget_instance.setMinimumHeight(400)

        # _g_my_widget_instance.setFixedWidth(1000) # 幅は親ウィジェットに追従させる方が良い場合もある
    elif agent is not None:
        _g_my_widget_instance.set_agent(agent)
    return _g_my_widget_instance

def excute(agent):
    try:
        app = _get_app_instance() # QApplicationインスタンスを取得または作成
        my_widget = _get_my_widget_instance(agent)
        app.setStyle("Fusion")
    # ChatWidget を表示するための親ウィジェットとレイアウト (オプション)
    # main_widget_for_excute = QWidget()
    # main_layout_for_excute = QVBoxLayout(main_widget_for_excute)
    # main_layout_for_excute.addWidget(my_widget)
    # main_widget_for_excute.show()
    # もしChatWidgetが直接トップレベルウィンドウとして機能するなら上記は不要
        my_widget.setGeometry(100, 100, 1000, 700) # 適当なサイズ
        my_widget.show()
#    except ImportError as e:
#        print(f" {e}")
        sys.exit(app.exec())
    except Exception as e:        
        print(f" {e}")
    # ComparisonGui.py がメインのイベントループを持つため、ここでは app.exec() を呼び出さない
    # paintgui.py が単体で実行される場合は、if __name__ == '__main__': の中で app.exec() を呼び出す





def set_agent(agent):
    my_widget = _get_my_widget_instance(agent)
    # my_widget.set_agent(agent) # _get_my_widget_instance 内で処理される

def update():
    my_widget = _get_my_widget_instance()
    my_widget.update()

def append_node(name,text):
    my_widget = _get_my_widget_instance()
    my_widget.append_node(name, text)

def append_text(text):
    my_widget = _get_my_widget_instance()
    if None is not my_widget:
        my_widget.append_text(text)

def set_last_node_text(text):
    my_widget = _get_my_widget_instance()
    my_widget.set_last_node_text(text)

def new_streaming_node(title):
    my_widget = _get_my_widget_instance()
    if hasattr(my_widget, 'new_streaming_node'):
        my_widget.new_streaming_node(title)

def get_stc_handler():
    my_widget = _get_my_widget_instance()
    return MyStreamlitCallbackHandler(my_widget)

def get_mywidget():
    return _get_my_widget_instance()

if __name__ == '__main__':
    app = _get_app_instance() # QApplicationインスタンスを取得または作成
    app.setStyle("Fusion")

    # ChatWidget を含むメインウィンドウのセットアップ
    main_widget = QWidget()
    main_layout = QVBoxLayout(main_widget)
    # from Agents.AICharacter import AICharacter # テスト用にインポート
    # test_agent = AICharacter("DummyAgentForPaintGUI", "System prompt for dummy", [])
    # my_widget = _get_my_widget_instance(test_agent)
    my_widget = _get_my_widget_instance(None) # エージェントなしで初期化
    main_layout.addWidget(my_widget)
    # main_layout.addStretch(0) # 必要に応じて
    
    main_widget.setWindowTitle("PaintGUI Standalone")
    main_widget.setGeometry(100, 100, 1000, 700) # 適当なサイズ
    main_widget.show()
    
    sys.exit(app.exec())