from ..core.AICharacter.AICharacter import AICharacter

from ..core.shared.program_called_command_list import load_ai_agent_name_list
from ..core.shared.program_called_command_list import get_main_agent_name_list
from ..core.shared.operational_command_list import load_operation_program_list

from ..core.Flow.AIOperation import AIOperation


from typing import Optional # Optional を追加


class ProgressManager():
    
    def __init__(self, max_check=3,
                 tools: list = [],
                 llm_model: Optional[str] = None,
                 **llm_provider_kwargs # LLMプロバイダ固有の引数をここで受け取る
                 ):
        name = "ProgressManager"
        self.agent_dict = load_ai_agent_name_list("ProgressManager")
        print(self.agent_dict)
        self.agent = AICharacter(name,
                             "",
                             [],
                             False,
                             llm_model=llm_model
                             )
        self.max_check = max_check
        self.temperature = 0.5
        self.latest_respons = ""
        load_operation_program_list()
        self.ai_operation = AIOperation()

    def get_name(self):
        return ProgressManager.__name__
    
    def clear_memory(self):
        self.agent.clear_memory()

    def update_temperature(self, temperature):
        self.temperature = temperature
        self.agent.update_temperature(temperature)

    def update_tools(self, tools):
        self.agent.update_tools(tools)

    def get_response(self, command, images_path=None):
        return self.progress_management(command, images_path=None)
    

################################################
    def __get_agent_prompt(self, name):
        return self.agent_dict[name][1]
    
    def progress_management(self, command, images_path=None):
        load_ai_agent_name_list()
        agent_list_str = get_main_agent_name_list()
        pre_prompt = "\r\n現在利用できるAICharacterは\r\n" + agent_list_str + "\r\n-------\r\n"
        
        