from ..core.AICharacter.AICharacter import AICharacter
from ..core.shared.program_called_command_list import load_ai_agent_name_list

from ..core.Flow.flow_controller import get_list_from_symbol_code
from typing import Optional # List, Optional, Tuple を追加

class MultiResultAgent():
    SELECT = 0
    MARGE = 1
    def __init__(self,
                 max_check=3,
                 tools: list = [],
                 llm_model: Optional[str] = None,
                 **llm_provider_kwargs # LLMプロバイダ固有の引数をここで受け取る
                 ):
        self.name = "MultiResultAgent"
        self.agent_dict = load_ai_agent_name_list("MultiResultAgent")
        print(self.agent_dict)
        self.agent = AICharacter(self.name,
                             "",
                             tools,
                             self.name)
        self.max_check = max_check
        self.temperature = 0.5
        self.latest_respons = ""
        self.user_command = ""
        self.type = self.SELECT
    def get_name(self):
        return MultiResultAgent.__name__

    # AICharacterと関数的互換性確保のために必要

    def clear_memory(self):
        self.agent.clear_memory()

    def update_temperature(self, temperature):
        self.temperature = temperature
        self.agent.update_temperature(temperature)

    def update_tools(self, tools):
        self.agent.update_tools(tools)

    def get_response(self, command, images_path=None):
        return self.function_create(command, images_path=None)

################################################
    def set_type(self, type):
        self.type = type

    def __get_agent_prompt(self, name):
        return self.agent_dict[name][1]

    def function_create(self, command, images_path=None):
        self.user_command = command
        # 複数アイデアだし
        self.agent.update_system_prompt(
            self.__get_agent_prompt("MultiRoute"))

        respons = self.agent.get_response(
            command+"\r\n-----\r\nを実現するためのアイデアを列挙してください。")

        idea_list = get_list_from_symbol_code(respons, "select")
        count = 0
        respons_list = []
        for idea in idea_list:
            agent = AICharacter(self.name+str(count),
                            "",
                            [],
                            False)
            agent.clear_memory()
            respons = agent.get_response(
                command+"\r\n-----\r\nを実現するため\r\n"+idea+"\r\nのアイデアの詳細をお願いします。")
            respons_list.append(respons)

            count += 1

        if self.SELECT == self.type:
            # 各アイデアのレスポンスで最も良いものを返す
            select_respons = ""
            for respons in respons_list:
                select_respons += respons + "\n\n"
            # 選択処理。ここでは単にリストを返す
            select_agent = AICharacter("select_agent", "", [], False)
            select_agent.update_temperature(self.temperature)
            select_agent.clear_memory()

            select_respons = select_agent.get_response(command + f"\n\nに対する回答として、以下の内容から最も適したものを１つ選んで抜粋してください。:\n\n{select_respons}")
            self.agent.update_system_prompt("")
            result = self.agent.get_response(
                select_respons+"\n\n"+"を用いて\n\n"+command+"\n\nを達成してください。")
            return result

            # return select_respons

        elif  self.MARGE == self.type:
            # 各アイデアのレスポンスを統合して返す
            # 統合処理。ここでは単純に結合して返す。
            marge_respons = ""
            for respons in respons_list:
                marge_respons += respons + "\n\n"

            # 追加: 統合結果に対してさらにエージェントに要約してもらう
            marge_agent = AICharacter("marge_agent", "", [], False)
            marge_agent.update_temperature(self.temperature)
            marge_agent.clear_memory()
            
            marge_respons = marge_agent.get_response(command + f"\n\nに対する回答として、以下の内容を統合して要約してください:\n\n{marge_respons}")
            self.agent.update_system_prompt("")
            result = self.agent.get_response(
                marge_agent+"\n\n"+"を用いて\n\n"+command+"\n\nを達成してください。")

            return result
