
from ..core.AICharacter.AICharacter import AICharacter
from ..core.shared.program_called_command_list import load_ai_agent_name_list

from typing import Optional # List, Optional, Tuple を追加
from ..function_calling import semantic_indexer
from  ..function_calling import web_search

from ..function_calling import takeover_memory 
from ..Applications import model_select as gui

class LongMemoryAgent():
    def __init__(self,
                 max_check=3,
                 tools: list = [],
                 llm_model: Optional[str] = None,
                 **llm_provider_kwargs, # LLMプロバイダ固有の引数をここで受け取る
                 ):
        name = "LongMemoryAgent"
        self.agetn_dict = load_ai_agent_name_list("LongMemoryAgent")

        self.memory_load_agent = AICharacter("LongMemoryLoad",
                     self.__get_agent_prompt("LongMemoryLoad"),
                     semantic_indexer.get_text_memory_search_tools(),
                     False,
                     llm_model=llm_model
                     )
        
        tools = semantic_indexer.get_tools_list()
        tools += web_search.get_tools_list() 
        
        self.agent = AICharacter(name,
                             self.__get_agent_prompt(name),
                             tools,
                             False,
                             llm_model=llm_model
                             )
        
        self.memory_save_agent = AICharacter("LongMemorySave",
                     self.__get_agent_prompt("LongMemorySave"),
                     semantic_indexer.get_text_memory_register_tool(),
                     False,
                     llm_model=llm_model
                     )

        self.takeover_agent = AICharacter("TakeoverAgent",
                     self.__get_agent_prompt("TakeoverAgent"),
                     takeover_memory.get_tools_list(),
                     False,
                     llm_model=llm_model
                     )

        self.serch_result = []
        self.max_check = max_check

    # AICharacterと関数的互換性確保のために必要
    def get_name(self):
        return LongMemoryAgent.__name__

    def clear_memory(self):
        self.agent.clear_memory()
        self.memory_load_agent.clear_memory()
        self.memory_save_agent.clear_memory()
        self.takeover_agent.clear_memory()

    def update_temperature(self, temperature):
        self.agent.update_temperature(temperature)

    def update_tools(self, tools):
        self.agent.update_tools(tools)

    def get_response(self, command, images_path=None):
        error_response, response_text = self.memory_use(command, images_path=None)
        return response_text
################################################

    def __get_agent_prompt(self, name):
        return self.agetn_dict[name][1]

    def memory_use(self, command, images_path=None):
        input_data=""

        ml_response = ""
        respons = ""
        user_input=f"user_input---\n{command}\n---\n"
        while True:
            self.__agent_action("LongMemoryLoad", "長期記憶データ", user_input)
            
            self.__agent_action("LongMemoryAgent", "実作業データ", user_input)
            
            if self.__agent_action("LongMemorySave", "長期記憶記録作業データ", user_input):
                break
        
        respons = takeover_memory._get_from_takeover_memory()

        return self.response(respons)

    def __set_takeover(self, input_data):
        gui.append_node("TakeoverAgent","")
        self.takeover_agent.get_response(input_data+ self.__get_agent_prompt("TakeoverAgent"))
        if takeover_memory.is_end_of_task():
            return True
        return False

    def __agent_action(self, agent_name, agent_data_tile, user_input):
        self.clear_memory()
        input_data = ""
        takeover = takeover_memory._get_from_takeover_memory()
        input_data += f"------\n引継ぎデーターーーー\n{takeover}\n---------\n"
        gui.append_node(agent_name,"")
        respons = self.agent.get_response(input_data + user_input + self.__get_agent_prompt(agent_name))
        input_data += f"{agent_data_tile}---\n{respons}\n---\n"
        return self.__set_takeover(input_data)



    def think_agent(self, prompt):

        # AIエージェントの思考
        #with st.chat_message("PythonProgramer"):
            # エージェントを実行
        response = self.agent.get_response(prompt)
        #    st.write(response)
        return response
