from flow.FlowBase import FlowBase
from Agents.AIAgent import AIAgent
from Agents.FunctionCreatorAgent import FunctionCreatorAgent
from Agents.FunctionExecuterAgent import FunctionExecuterAgent
# from Agents.OperationcodeCreatorAgent import OperationcodeCreatorAgent
from Agents.PythonTestProgramerAgent import PythonTestProgramerAgent
from Agents.PythonProgramerAgent import PythonProgramerAgent
from Agents.WebSerchAgent import WebSerchAgent
from tools.command_list import get_tools_list


class FlowProcessAIAgent(FlowBase):
    def __init__(self, name, prompt):
        super().__init__()
        self.set_category("flow")
        self.set_type("process")
        self.agent = self.get_ai_agent(name)
        self.prompt = prompt
        self.name = name

    def get_ai_agent(self, name):
        if "なし" == name:
            return AIAgent("None", "", get_tool_list())
        if "WebSerchAgent" == name:
            return WebSerchAgent()
        if "PythonProgramerAgent" == name:
            return PythonProgramerAgent()
        if "PythonTestProgramerAgent" == name:
            return PythonTestProgramerAgent()
        if "OperationcodeCreatorAgent" == name:
            from Agents.OperationcodeCreatorAgent import OperationcodeCreatorAgent
            return OperationcodeCreatorAgent()
        if "FunctionCreatorAgent" == name:
            return FunctionCreatorAgent()
        if "FunctionExecuterAgent" == name:
            return FunctionExecuterAgent()
#        return AIAgent(name, "", get_tool_list())
        return AIAgent(name, "", [])

    def run(self, command="", pre_respons=None, flow_data=None):
        data = f"""
------------大元の指示----------
        {command}
-------今回の指示---------------
        {self.prompt}
-----------------------------
        """
        print("FlowProcessAIAgent.run:", data)
        print("agent_name:", self.agent.get_name())
        if "User" == self.agent.get_name():
            return "return", pre_respons
        respons = self.agent.get_response(data)
        print("agent_name respons\r\n:", respons)
        print(f"--------endof {self.agent.get_name()}----------------------", )
        return "", respons

    def append_prompt(self, text):
        self.prompt += "\r\n" + text
