from flow.FlowBase import FlowBase


from Agents.AIAgent import AIAgent
from flow.flow_controller import get_python_line_start_sharp_comment_from_respons
import copy
import random


# 判別のみを担当
class FlowCriterionAndBranching(FlowBase):
    def __init__(self):
        super().__init__()
        self.set_category("flow")
        self.set_type("condision")
        self.agent = AIAgent("FlowCondisionAndBranching", "", [])
        self.select_type = "one"
        self.threshold = 0
        self.criterion = ""  # 判別条件
        self.branching_list = []

    def set_select_type(self, type):
        self.select_type = type

    def set_criterion(self, criterion):
        self.criterion = criterion

    def set_branching(self, branching_list):
        self.branching_list = branching_list

    def append_branching(self, branching):
        self.branching_list.append(branching)

    def set_threshold(self, threshold):
        self.threshold = threshold

    def check(self):
        if "one" == self.select_type:
            prompt = "これまでの経緯と要望から、以下の判別条件:"+self.criterion+"\
:を用い、以下の選択肢からひとつ選択して、pythonプログラムの#で始まるコメントとして出力してください。\r\n"
            for data in self.branching_list:
                prompt += data + "\r\n"
            self.agent.update_system_prompt("")
            respons = self.agent.get_response(prompt)
            list = get_python_line_start_sharp_comment_from_respons(respons)
            if 0 < len(list):
                if 0 < len(list[0]):
                    result = list[0]
                    return result.strip()

        elif "rand" == self.select_type:
            buf = copy.deepcopy(self.branching_list)
            random.shuffle(buf)
            return buf[0]
            pass
        elif "ratio" == self.select_type:
            prompt = "これまでの経緯と要望から、以下の判別条件:"+self.criterion+"\
:を用い、以下の選択肢全ての重要度を（小0～100大）の値で表して、\
pythonプログラムの#で始まるコメントとして\r\n#項目名:重要度\r\nの書式で出力してください。\r\n"
            for data in self.branching_list:
                prompt += data + "\r\n"
            self.agent.update_system_prompt("")
            # Aiに判断させる
            respons = self.agent.get_response(prompt)
            # pythonプログラムで#で始まるコメント行を取得
            list = get_python_line_start_sharp_comment_from_respons(respons)
            branching_dict = {}
            # 出力データを:で分割し、分岐内容ごとの重要度を取得
            max = 0
            for line in list:
                data_list = line.split(":")
                if 1 < len(data_list):
                    branching_dict[data[0]] = int(data[1])
                    if 0 < self.threshold:  # 閾値より小さいとき無視する
                        max += int(data[1])
            # 有効な重要度総和の範囲で乱数を発生。
            rand_value = random.randint(0, max)
            value_position = 0
            # どの分岐が選ばれたか確認
            for key, value in branching_dict.items():
                if self.threshold < value:  # 閾値より小さいとき無視する
                    if value_position < rand_value and\
                          rand_value <= value_position + value:
                        return result.strip(key)
                    value_position += value
                pass
            if 0 == max:
                print("選択に値する選択肢が見つかりませんでした。")
        return None
