from Agents.AIAgent import AIAgent
from tools.program_called_command_list import load_ai_agent_name_list
import flow.flow_controller
from typing import Optional # List, Optional, Tuple を追加



class PythonProgramerAgent():
    def __init__(self,
                 max_check=3,
                 tools: list = [],
                 llm_model: Optional[str] = None,
                 **llm_provider_kwargs, # LLMプロバイダ固有の引数をここで受け取る
                 ):
        name = "PythonProgramer"
        self.agetn_dict = load_ai_agent_name_list("PythonProgramerAgent")
        
        self.agent = AIAgent(name,
                             self.__get_agent_prompt(name),
                             [],
                             False,
                             llm_model=llm_model
                             )
        self.serch_result = []
        self.max_check = max_check

    # AIAgentと関数的互換性確保のために必要
    def get_name(self):
        return PythonProgramerAgent.__name__

    def clear_memory(self):
        self.agent.clear_memory()

    def update_temperature(self, temperature):
        self.agent.update_temperature(temperature)

    def update_tools(self, tools):
        self.agent.update_tools(tools)

    def get_response(self, command, images_path=None):
        error_response, response_text = self.program(command, images_path=None)
        return response_text
################################################

    def __get_agent_prompt(self, name):
        return self.agetn_dict[name][1]

    def program(self, command, images_path=None):
        self.agent.update_system_prompt(
            self.__get_agent_prompt("PythonProgramer"))
        # コールバック関数の設定 (エージェントの動作の可視化用)

        respons = self.agent.get_response(command)
        return self.response_programe_check(respons)

    def response_programe_check(self, check_prompt):
        # 次の作業者を決定。
        count = 0
        respons_text = check_prompt
        # pythonで エラーが出るようなら自動で作りなおしを依頼。
        print("response_programe_check:", respons_text)
        while True:
            error_respons =\
                flow.flow_controller.python_error_check(respons_text)
            if False is flow.flow_controller.get_code_error():
                error_respons = ""
                return error_respons, respons_text
            if self.max_check <= count:
                error_respons = "3回以上やり直してもエラーを修正しきれませんでした。"
                return error_respons, respons_text
            print(error_respons)

            respons_text =\
                self.think_agent(error_respons+"\r\n原因と対策を確認したうえで、直してください。")
            count += 1

    def think_agent(self, prompt):

        # AIエージェントの思考
        #with st.chat_message("PythonProgramer"):
            # エージェントを実行
        response = self.agent.get_response(prompt)
        #    st.write(response)
        return response
