
from pydantic import (BaseModel, Field)

from tools.program_called_command_list import save_text
from tools.program_called_command_list import load_text
####################################################


class ToolsDataBase():
    def __init__(self):
        self.operation_program_dict = {}


g_tdb = ToolsDataBase()


##########################################################
def __load_operation_file(fname):
    if not fname.endswith(".op"):
        fname += ".op"
    return load_text("Operation/"+fname)


def get_operation_code(fname):
    if fname in g_tdb.operation_program_dict.keys():
        return g_tdb.operation_program_dict[fname]
    return ""


def load_operation_program_list():
    data = load_text("Operation/operation_program_function_list.list")
    if None is data:
        return 
    lines = data.split("\n")
    for line in lines:
        l_line = line.rstrip()
        data_list = l_line.split(":")
        if None is not data_list:
            if 1 < len(data_list):
                g_tdb.operation_program_dict[data_list[0]] =\
                    [data_list[1], __load_operation_file(data_list[0])]


def __save_operation_file(fname, data):
    if not fname.endswith(".op"):
        fname += ".op"

    save_text("Operation/"+fname, data)


def __save_operation_list(fname, data):
    if not fname.endswith(".list"):
        fname += ".list"

    save_text("Operation/"+fname, data)


def __get_operation_program_list():
    data = ""
    for key in g_tdb.operation_program_dict.keys():

        data += key + ":" + g_tdb.operation_program_dict[key][0]
        data += "\n"
    return data


def get_operation_program_list():
    return __get_operation_program_list()


class operationProgramFunctionData(BaseModel):
    function_name: str = Field()
    explanation: str = Field()
    program: str = Field()


def append_operation_program_function_direct(function_name=None,
                                             explanation="", program=""):
    """
        operationプログラムで書かれた機能追加します。
        既に存在している場合何もしません。
    Args:
        function_name:機能の名前。半角英数のみ利用できます。:
        explanation:機能が何をする機能か簡易な説明。:
        program:機能を実現するためのoperationのプログラム

    """
    print("append_ai_agent:", function_name)

    if function_name not in g_tdb.operation_program_dict:

        g_tdb.operation_program_dict[function_name] = [explanation, program]
        __save_operation_list("operation_program_function_list.list",
                              __get_operation_program_list())
        __save_operation_file(function_name+".op", program)
