from Agents.AIAgent import AIAgent
from tools.program_called_command_list import load_ai_agent_name_list
from tools.program_called_command_list import get_main_agent_name_list
from flow.flow_controller import get_list_from_symbol_code
from tools.operational_command_list import load_operation_program_list


from Agents.FunctionCreatorAgent import FunctionCreatorAgent
from Agents.FunctionExecuterAgent import FunctionExecuterAgent
from Agents.OperationcodeCreatorAgent import OperationcodeCreatorAgent
from Agents.PythonTestProgramerAgent import PythonTestProgramerAgent
from Agents.PythonProgramerAgent import PythonProgramerAgent

from Agents.WebSerchAgent import WebSerchAgent
from typing import Optional # Optional を追加

class RooterAgent():
    def __init__(self,
                 max_check=3,
                 tools: list = [],
                 llm_model: Optional[str] = None,
                 **llm_provider_kwargs # LLMプロバイダ固有の引数をここで受け取る
                 ):
        name = "Rooter"
        self.agent_dict = load_ai_agent_name_list("RooterAgent")
        print(self.agent_dict)
        self.agent = AIAgent(name,
                             "",
                             [],
                             False,
                             llm_model=llm_model,
                             )
        self.max_check = max_check
        self.temperature = 0.5
        self.latest_respons = ""

    def get_name(self):
        return RooterAgent.__name__

    # AIAgentと関数的互換性確保のために必要

    def clear_memory(self):
        self.agent.clear_memory()

    def update_temperature(self, temperature):
        self.temperature = temperature
        self.agent.update_temperature(temperature)

    def update_tools(self, tools):
        self.agent.update_tools(tools)

    def get_response(self, command, images_path=None):
        return self.rooter(command, images_path=None)

################################################
    def __get_agent_prompt(self, name):
        return self.agent_dict[name][1]
    
    def rooter(self, command, images_path=None):
        load_ai_agent_name_list()
        agent_list_str = get_main_agent_name_list()
        pre_prompt = "\r\n現在利用できるAIAgentは\r\n" + agent_list_str + "\r\n-------\r\n"
        print("agent_list_str",agent_list_str)
        # アイデアだし
        self.agent.update_system_prompt(
            self.__get_agent_prompt("Rooter"))
        # コールバック関数の設定 (エージェントの動作の可視化用)

        respons = self.agent.get_response(
            pre_prompt + command, images_path)
        code_list = get_list_from_symbol_code(respons, "rooter")
        if None is code_list:
            return respons
        else:
            if 0 < len(code_list):
                object = self.get_ai_agent(code_list[0])
                AIAgent.increment_indentation()
                respons = object.get_response(command, images_path)
                AIAgent.decrement_indentation()
            return respons

    def get_ai_agent(self, name):
        if "なし" == name:
            return AIAgent("None", "", get_tool_list())
        if "WebSerchAgent" == name:
            return WebSerchAgent()
        if "PythonProgramerAgent" == name:
            return PythonProgramerAgent()
        if "PythonTestProgramerAgent" == name:
            return PythonTestProgramerAgent()
        if "OperationcodeCreatorAgent" == name:
            return OperationcodeCreatorAgent()
        if "FunctionCreatorAgent" == name:
            return FunctionCreatorAgent()
        if "FunctionExecuterAgent" == name:
            return FunctionExecuterAgent()

        return AIAgent(name, "", [])