import pyttsx3
import platform

def speak(text: str):
    """
    指定されたテキストを音声で読み上げます。
    OSに応じて最適なエンジンを試みます。
    """
    try:
        engine = None
        # Windowsの場合、より高品質なSAPI5を試す
        if platform.system() == 'Windows':
            try:
                engine = pyttsx3.init('sapi5')
            except Exception:
                pass  # sapi5が利用できない場合はデフォルトにフォールバック

        if engine is None:
            engine = pyttsx3.init()

        # --- 声を高くするための処理を追加 ---
        # 利用可能な声のリストを取得
        voices = engine.getProperty('voices')

        # # 利用可能な声の情報を確認したい場合は、以下の3行のコメントを解除してください
        # for voice in voices:
        #     print(f" - ID: {voice.id}, Name: {voice.name}, Lang: {getattr(voice, 'languages', [])}, Gender: {getattr(voice, 'gender', 'N/A')}")

        # 女性の声を探す（声が高くなる傾向がある）
        target_voice_id = None

        # Windowsの場合、日本語の女性の声を探す
        if platform.system() == 'Windows':
            # 'Haruka' や 'Ayumi' は一般的な日本語女性音声
            target_voice_id = next((voice.id for voice in voices if 'haruka' in voice.name.lower() or 'ayumi' in voice.name.lower()), None)

        # 見つかった場合、または他のOSで女性の声が見つかった場合に設定
        if target_voice_id:
            print(f"女性の声を設定します: {target_voice_id}")
            engine.setProperty('voice', target_voice_id)
        else:
            print("特定の女性の声が見つかりませんでした。デフォルトの声を使用します。")
        # --- ここまで ---

        # 声の速度を設定 (デフォルトは200)
        engine.setProperty('rate', 180)
        # 音量を設定 (0.0から1.0)
        engine.setProperty('volume', 1.0)

        engine.say(text)
        engine.runAndWait()
    except Exception as e:
        print(f"音声の読み上げ中にエラーが発生しました: {e}")
        print("音声合成エンジンが利用できない可能性があります。")
