import os
import time

####################################################
# PYTHON_PATH = "user python path"

# 環境変数を取得する例
# 取得したい環境変数名を指定
env_var_name = "AI_USE_PYTHON_PATH"

# os.getenv() で取得（存在しない場合は None を返す）
PYTHON_PATH = os.getenv(env_var_name)

if PYTHON_PATH is None:
    env_var_name = "PYTHON_PATH"
    PYTHON_PATH = os.getenv(env_var_name)
    if PYTHON_PATH is None:
        print("error:環境変数AI_USE_PYTHON_PATHまたはPYTHON_PATHが設定されていません。")
####################################################


class ToolsDataBase():
    def __init__(self):
        self.python_program_dict = {}
        self.ai_agent_dict = {}
        self.main_ai_agent_dict = {}

g_tdb = ToolsDataBase()


def create_folder(folder_path):
    """指定されたフォルダが存在しない場合、フォルダを作成します。

    Args:
      folder_path: 作成するフォルダのパス。
    """
    folder_path = folder_path.replace("\\", "/")
    if not os.path.exists(folder_path):
        os.makedirs(folder_path)
    if folder_path.endswith("/"):
        return folder_path
    else:
        return folder_path + "/"

def get_parent_directory(file_path):
    """__file__からファイル名を除いてさらに親フォルダのパスを得る関数。

    Args:
        file_path: ファイルのパス。

    Returns:
        親フォルダのパス。ファイルが存在しない場合はNoneを返す。
    """
    if not os.path.exists(file_path):
        return None
    parent_dir = os.path.dirname(file_path)
    grandparent_dir = os.path.dirname(parent_dir)
    return grandparent_dir


WORK_SPACE_DIR = create_folder(get_parent_directory(__file__))
AGENT_SPACE_DIR = create_folder(WORK_SPACE_DIR + "Agents")
CODE_SPACE_DIR = create_folder(WORK_SPACE_DIR + "Code")
DELOVERABLES_SPACE_DIR = create_folder(WORK_SPACE_DIR + "Deliverables")
TEMP_SPACE_DIR = create_folder(WORK_SPACE_DIR + "Temp")


def set_agent_space(space):
    global AGENT_SPACE_DIR
    AGENT_SPACE_DIR = create_folder(space)


def set_code_space(space):
    global CODE_SPACE_DIR
    CODE_SPACE_DIR = create_folder(space)


def set_deliverables_space(space):
    global DELOVERABLES_SPACE_DIR
    DELOVERABLES_SPACE_DIR = create_folder(space)


def set_temp_space(space):
    global TEMP_SPACE_DIR
    TEMP_SPACE_DIR = create_folder(space)


def set_work_space(space):
    global WORK_SPACE_DIR
    WORK_SPACE_DIR = create_folder(space)
    WORK_SPACE_DIR = WORK_SPACE_DIR.replace("\\", "/")

    set_agent_space(WORK_SPACE_DIR+"Agents")
    set_code_space(WORK_SPACE_DIR+"Code")
    set_deliverables_space(WORK_SPACE_DIR+"Deliverables")
    set_temp_space(WORK_SPACE_DIR+"Deliverables")
####################################################


def save_text(file_name, data):
    file_name = file_name.replace("../", "")
    file_name = file_name.replace("..\\", "")
    data = data.replace("\\r", "\r")
    data = data.replace("\\n", "\n")
    try:
        with open(WORK_SPACE_DIR+file_name, 'wb') as f_out:
            f_out.write(data.encode())
    except PermissionError:
        print(f"ファイルへの書き込み権限がありません: {file_name}")
    except OSError as e:
        print(f"ファイル書き込み中にエラーが発生しました: {e}")
    except Exception as e:
        print(f"ファイル書き込み中にエラーが発生しました: {e}")


def load_text(file_name):
    file_name = file_name.replace("../", "")
    file_name = file_name.replace("..\\", "")
    full_path = WORK_SPACE_DIR+file_name
    if os.path.exists(full_path):
        try:
            with open(full_path, 'rb') as f_in:
                data = f_in.read()
            return data.decode('utf-8')

        except Exception as e:
            print(f"ファイル読み込み中にエラーが発生しました: {e}")

    else:
        print(f"{full_path}\r\nファイルが見つかりませんでした")
    return None

##########################################################


def save_program_file(file_name, data):
    """
    pythonコードを保存します。
    Args:
        data:pythonコード
    """
    print("save_python_file:")
    save_text("Code/" + file_name, data)


def load_python_file(file_name):
    """
    pythonコードを読み込みます。
    Returns:
        読み込んだpythonコードを返します
    """
    print("load_python_file:")
    result = load_text("Code/" + file_name)
    return result


##########################################################
def __load_python_file(fname):
    if not fname.endswith(".py"):
        fname += ".py"
    return load_text("Code/"+fname)


def get_python_code(fname):
    global g_tdb
    if fname in g_tdb.python_program_dict.keys():
        return g_tdb.python_program_dict[fname]
    return ""


def load_python_program_list():
    global g_tdb
    data = load_text("Code/python_program_function_list.list")
    if None is data:
        return
    lines = data.split("\n")
    for line in lines:
        l_line = line.rstrip()
        data_list = l_line.split(":")
        if None is not data_list:
            if 1 < len(data_list):
                g_tdb.python_program_dict[data_list[0]] =\
                    [data_list[1], __load_python_file(data_list[0])]


def __save_python_file(fname, data):
    if not fname.endswith(".py"):
        fname += ".py"

    save_text("Code/"+fname, data)


def __save_python_list(fname, data):
    if not fname.endswith(".list"):
        fname += ".list"

    save_text("Code/"+fname, data)


def __get_python_program_list():
    global g_tdb
    data = ""
    for key in g_tdb.python_program_dict.keys():

        data += key + ":" + g_tdb.python_program_dict[key][0]
        data += "\n"
    return data


def get_python_program_list():
    return __get_python_program_list()


def append_python_program_function_direct(function_name=None,
                                          explanation="", program=""):
    """
        pythonプログラムで書かれた機能追加します。
        既に存在している場合何もしません。
    Args:
        function_name:機能の名前。半角英数のみ利用できます。:
        explanation:機能が何をする機能か簡易な説明。:
        program:機能を実現するためのpythonのプログラム

    """
    global g_tdb
    print("append_ai_agent:", function_name)

    if function_name not in g_tdb.python_program_dict:

        g_tdb.python_program_dict[function_name] = [explanation, program]
        __save_python_list("python_program_function_list.list",
                           __get_python_program_list())
        if None is program:
            print("append_python_program_function_direct : programが空です。")
        else:
            __save_python_file(function_name+".py", program)

####################################################


def load_agent_file(file_name):
    result = load_text("Agents/" + file_name)
    return result


def load_ai_agent_name_list(folder=None):
    global g_tdb
    print("load_ai_agent_name_list:")

    result_dict = {}
    if None is folder or 0 == len(folder):
        g_tdb.main_ai_agent_dict = {}
    else:
        # folder指定されている場合ai_agent_dictを初期化
        g_tdb.ai_agent_dict = {}
        if 0 < len(folder):
            if "\\" != folder[-1] or "/" != folder[-1]:
                folder += "/"
    if None is folder:
        folder = "" 
#    print("folder",folder)
    data = load_agent_file(folder + "ai_agent_name_list.list")
    data_list = data.split("\r\n")

    list_buf = []
    for data in data_list:
#        print("data",data)
        list_buf = data.split(":")
        # 説明文にがあった場合の処理
        if 3 <= len(list_buf):
            buf = ""
            for i in range(2, len(list_buf)):
                buf += list_buf[i]
                # list_bufのリストの最後の時は:を追加しない
                if i != len(list_buf) - 1:
                    buf += ":"
#            print("list_buf[1].lower()",list_buf[1].lower())
            if "n" == list_buf[1].lower():
                result_dict[list_buf[0]] = [buf, None, "n"]
            elif "f" == list_buf[1].lower():
                # フォルダ指定されてないときファイルはCharactersフォルダにある
                current_folder = folder
                if None is folder or "" == folder:
                    current_folder = "Characters/"
                prompt = load_agent_file(current_folder + list_buf[0]+".txt")
                result_dict[list_buf[0]] = [buf, prompt, "f"]
            elif "c" == list_buf[1].lower():
                result_dict[list_buf[0]] = [buf, None, "c"]
    if None is folder or 0 == len(folder):
        g_tdb.main_ai_agent_dict = result_dict
    else:
        g_tdb.ai_agent_dict = result_dict        
    #print("folder", result_dict)
    #print("g_tdb.main_ai_agent_dict", g_tdb.main_ai_agent_dict)
    return result_dict


def get_main_agent_name_list():
    return __get_agent_name_list()


def __get_agent_name_list():
    global g_tdb
    result = ''
    #print("g_tdb.main_ai_agent_dict", g_tdb.main_ai_agent_dict)
    for key, value in g_tdb.main_ai_agent_dict.items():
        result += key + ':' + value[0] + '\r\n'
    return result


class Timekeeper():
    interval = 4.1
    def __init__(self):
        self.time_buffer = time.time()
        self.interval = 4.1

    def wait(self):
        time_buf = self.interval - (time.time()-self.time_buffer)
        print("time_buf", time_buf)
        if 0 < time_buf:
            time.sleep(time_buf)
        self.time_buffer = time.time()
    @classmethod
    def set_interval(cls,interval):
        cls.interval = interval

g_time_keeper = Timekeeper()


def wait_safety():
    global g_time_keeper
    g_time_keeper.wait()
