from flow.FlowSelect import FlowSelect
from flow.FlowSequentialBase import FlowSequentialBase

class FlowIf(FlowSelect):
    def __init__(self, criterion=None):
        super().__init__(criterion)
        self.set_category("flow")
        self.set_type("if")
        if None is not criterion:
            super().set_criterion_and_branching(criterion,
                                                ["True", "False"])

    def append_process(self, process, branching):
        # True False 以外は無視する
        if "True" == branching:
            super().append_process(process, "True")
        elif "False" == branching:
            super().append_process(process, "False")

    def set_criterion(self, criterion):
        super().set_criterion_and_branching(criterion,
                                            ["True", "False"])



    # ────── ここから追加 ──────
    
    def create_else_steps(self):
        """
        `else` ブロックの処理を構築する
        Returns:
            FlowSequentialBase: `else` ブロックのシーケンシャルフロー
        """
        # else 用のシーケンシャルフローを用意
        self.else_flow = FlowSequentialBase()
        # 「False」分岐として内部に追加
        self.append_process(self.else_flow, "False")
        # 再帰的に子フローを構築
        return self.else_flow
       
    # ────── ここまで ──────